/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.datergf;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.oorexx.datergf.DateRGF;
import org.oorexx.datergf.DateTimeRGF;
import org.oorexx.datergf.TimeRGF;

public class DateFormatRGF {
    public static String version = "92.20060101";
    public static final String[] romanL = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x", "xi", "xii"};
    public static final String[] romanU = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};
    protected static char[] options = new char[]{'y', 'M', 'd', 'h', 'H', 'm', 's', 'S', 'E', 'e', 'o', 'R', 'r', 'D', 'g', 'w', 'a', 'k', 'K'};

    public static String format(String string, Object object) {
        if (object == null) {
            return string;
        }
        DateTimeRGF dateTimeRGF = null;
        if (object instanceof DateTimeRGF) {
            dateTimeRGF = (DateTimeRGF)object;
        } else if (object instanceof DateRGF) {
            dateTimeRGF = new DateTimeRGF((DateRGF)object, new TimeRGF());
        } else if (object instanceof TimeRGF) {
            dateTimeRGF = new DateTimeRGF(new DateRGF(), (TimeRGF)object);
        } else {
            return string;
        }
        int n = string.length();
        String string2 = "";
        String string3 = "";
        block15: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\"') {
                if (string3.length() > 0) {
                    string2 = string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
                    string3 = "";
                }
                if (c == (i + 1 < n ? string.charAt(i + 1) : (char)'?')) {
                    string2 = string2 + c;
                    ++i;
                    continue;
                }
                while (i < n) {
                    int n2 = DateFormatRGF.pos(c, string, i + 1);
                    if (n2 == -1) {
                        return string2 + string.substring(i);
                    }
                    string2 = string2 + string.substring(i + 1, n2);
                    i = n2;
                    if (c != (n2 + 1 < n ? string.charAt(n2 + 1) : (char)'?')) continue block15;
                    string2 = string2 + c;
                    ++i;
                }
                continue;
            }
            if (c == '%') {
                if (string3.length() > 0) {
                    string2 = string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
                    string3 = "";
                }
                if (++i > n) {
                    return string2 + c;
                }
                c = string.charAt(i);
                switch (c) {
                    case '%': {
                        string2 = string2 + c;
                        continue block15;
                    }
                    case 'e': {
                        string3 = "d";
                        break;
                    }
                    case 'd': {
                        string3 = "dd";
                        break;
                    }
                    case 'a': {
                        string3 = "E";
                        break;
                    }
                    case 'A': {
                        string3 = "EEEE";
                        break;
                    }
                    case 'm': {
                        string3 = "MM";
                        break;
                    }
                    case 'b': {
                        string3 = "MMM";
                        break;
                    }
                    case 'B': {
                        string3 = "MMMM";
                        break;
                    }
                    case 'w': {
                        string3 = "e";
                        break;
                    }
                    case 'W': {
                        string3 = "ww";
                        break;
                    }
                    case 'y': {
                        string3 = "y";
                        break;
                    }
                    case 'Y': {
                        string3 = "yyy";
                        break;
                    }
                    case 'j': {
                        string3 = "DDD";
                        break;
                    }
                    default: {
                        string2 = string2 + "%" + c;
                        continue block15;
                    }
                }
                string2 = string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
                string3 = "";
                continue;
            }
            if (DateFormatRGF.verify(c, options) == -1) {
                if (string3.length() > 0) {
                    string2 = string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
                    string3 = "";
                }
                string2 = string2 + c;
                continue;
            }
            if (string3.length() == 0 || c == string3.charAt(0)) {
                string3 = string3 + c;
                continue;
            }
            string2 = string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
            string3 = "" + c;
        }
        if (string3.length() > 0) {
            return string2 + DateFormatRGF.dateval(string3, dateTimeRGF);
        }
        return string2;
    }

    private static String dateval(String string, DateTimeRGF dateTimeRGF) {
        int n = string.length();
        int n2 = -1;
        char c = string.charAt(0);
        switch (c) {
            case 'd': {
                if (n == 1) {
                    return "" + dateTimeRGF.date.day;
                }
                return DateRGF.ri(dateTimeRGF.date.day, 2);
            }
            case 'E': {
                String string2 = DateRGF.getString(-280, DateRGF.dow(dateTimeRGF.date));
                if (n < 4 && string2.length() > 2) {
                    return string2.substring(0, 3);
                }
                return string2;
            }
            case 'M': {
                if (n == 1) {
                    return "" + dateTimeRGF.date.month;
                }
                if (n == 2) {
                    return DateRGF.ri(dateTimeRGF.date.month, 2);
                }
                String string3 = DateRGF.getString(-302, dateTimeRGF.date.month);
                if (n == 3 && string3.length() > 2) {
                    return string3.substring(0, 3);
                }
                return string3;
            }
            case 'e': {
                return "" + DateRGF.dow(dateTimeRGF.date);
            }
            case 'w': {
                n2 = DateRGF.isoWeek(dateTimeRGF.date);
                if (n == 1) {
                    return "" + n2;
                }
                return DateRGF.ri(n2, 2);
            }
            case 'o': {
                return "" + DateRGF.dow_ord(dateTimeRGF.date);
            }
            case 'y': {
                if (n == 1) {
                    return "" + dateTimeRGF.date.year % 100;
                }
                if (n == 2) {
                    return DateRGF.ri(dateTimeRGF.date.year % 100, 2);
                }
                if (n == 3) {
                    return "" + dateTimeRGF.date.year;
                }
                return DateRGF.ri(dateTimeRGF.date.year, 4);
            }
            case 'r': {
                return romanL[dateTimeRGF.date.month - 1];
            }
            case 'R': {
                return romanU[dateTimeRGF.date.month - 1];
            }
            case 'D': 
            case 'g': {
                int n3 = 0;
                n3 = c == 'D' ? dateTimeRGF.date.get(-203) - new DateRGF(dateTimeRGF.date.year, 1, 1).get(-203) + 1 : new DateRGF(dateTimeRGF.date.year, 12, 31).get(-203) - dateTimeRGF.date.get(-203);
                if (n == 1) {
                    return "" + n3;
                }
                if (n == 2) {
                    return DateRGF.ri(n3, 2);
                }
                return DateRGF.ri(n3, 3);
            }
            case 'H': 
            case 'K': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': {
                if (c == 'm') {
                    n2 = dateTimeRGF.time.minute;
                } else if (c == 's') {
                    n2 = dateTimeRGF.time.second;
                } else if (c == 'H') {
                    n2 = dateTimeRGF.time.hour;
                } else if (c == 'k') {
                    n2 = dateTimeRGF.time.hour;
                    if (n2 == 0) {
                        n2 = 24;
                    }
                } else if (c == 'K' || c == 'h') {
                    n2 = dateTimeRGF.time.hour % 12;
                    if (c == 'h' && n2 == 0) {
                        n2 = 12;
                    }
                }
                if (n == 1) {
                    return "" + n2;
                }
                return DateRGF.ri(n2, 2);
            }
            case 'S': {
                if (n == 1) {
                    return "" + dateTimeRGF.time.millis;
                }
                if (n == 2) {
                    return DateRGF.ri(dateTimeRGF.time.millis, 2);
                }
                return DateRGF.ri(dateTimeRGF.time.millis, 3);
            }
            case 'a': {
                return TimeRGF.am_pm_string[dateTimeRGF.time.hour < 12 ? 0 : 1];
            }
        }
        return string;
    }

    protected static int verify(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    protected static int pos(char c, String string, int n) {
        if (n > string.length()) {
            return -1;
        }
        for (int i = n; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static void localize() {
        DateFormatRGF.localize(Locale.getDefault());
    }

    public static void localize(Locale locale) {
        char c;
        boolean bl;
        if (locale == null) {
            locale = Locale.getDefault();
        } else {
            Locale.setDefault(locale);
        }
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone timeZone2 = TimeZone.getTimeZone("GMT-0:00");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        DateFormat dateFormat2 = DateFormat.getTimeInstance(3, locale);
        int n = dateFormat.getCalendar().getFirstDayOfWeek();
        int n2 = n - 1;
        if (n2 == 0) {
            n2 = 7;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = true;
        int n6 = 2001;
        int n7 = 1;
        int n8 = 8;
        int n9 = 18;
        int n10 = 22;
        int n11 = 33;
        long l = 978978153000L;
        long l2 = 978934953000L;
        Date date = new Date(l);
        String string = DateFormat.getDateInstance(3, locale).format(date);
        String string2 = DateFormat.getTimeInstance(3, locale).format(date);
        int n12 = -1;
        String string3 = "";
        int n13 = DateFormatRGF.findFirstDigit(string);
        if (n13 != -1) {
            string3 = "";
            bl = false;
            while (n13 < string.length()) {
                c = string.charAt(n13);
                if (c < '0' || c > '9') {
                    n3 = c;
                    n12 = DateFormatRGF.toInt(string3, 0, 99);
                    break;
                }
                string3 = string3 + c;
                ++n13;
            }
        }
        if (n12 == -1) {
            n3 = 45;
            n5 = -1;
            n2 = 1;
        } else {
            n5 = n12 == n7 ? -2 : (n12 == n8 ? -3 : -1);
        }
        DateRGF.setStatic(-340, n2);
        DateRGF.setStatic(-5, (byte)n5);
        DateRGF.dateSeparator = (char)n3;
        n12 = -1;
        if (n13 != -1) {
            string3 = "";
            bl = false;
            for (n13 = DateFormatRGF.findFirstDigit(string2); n13 < string2.length(); ++n13) {
                c = string2.charAt(n13);
                if (c < '0' || c > '9') {
                    n4 = c;
                    n12 = DateFormatRGF.toInt(string3, 0, 99);
                    break;
                }
                string3 = string3 + c;
            }
        }
        if (n12 == -1) {
            n4 = 58;
            bl2 = true;
        } else {
            bl2 = n12 > 12;
        }
        TimeRGF.timeSeparator = (char)n4;
        TimeRGF.is24Hour = bl2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEEE");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("MMMM");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("a");
        String string4 = simpleDateFormat.format(gregorianCalendar.getGregorianChange(), new StringBuffer(), new FieldPosition(1)).toString();
        DateRGF dateRGF = new DateRGF(DateFormatRGF.toInt(string4, 0, 4), DateFormatRGF.toInt(string4, 4, 2), DateFormatRGF.toInt(string4, 6, 2));
        DateRGF.setGregorianChange(dateRGF.year, dateRGF.month, dateRGF.day);
        TimeZone.setDefault(timeZone2);
        String[] stringArray = new String[7];
        for (n13 = 0; n13 < 7; ++n13) {
            date.setTime(l + (long)(n13 * 86400) * 1000L);
            stringArray[n13] = simpleDateFormat2.format(date, new StringBuffer(), new FieldPosition(1)).toString();
        }
        DateRGF.setString(-280, stringArray);
        stringArray = new String[12];
        long l3 = 2678400000L;
        for (n13 = 0; n13 < 12; ++n13) {
            date.setTime(l + (long)n13 * l3);
            stringArray[n13] = simpleDateFormat3.format(date, new StringBuffer(), new FieldPosition(1)).toString();
        }
        DateRGF.setString(-302, stringArray);
        stringArray = new String[2];
        date.setTime(l2);
        stringArray[0] = simpleDateFormat4.format(date, new StringBuffer(), new FieldPosition(1)).toString();
        date.setTime(l);
        stringArray[1] = simpleDateFormat4.format(date, new StringBuffer(), new FieldPosition(1)).toString();
        TimeRGF.am_pm_string = stringArray;
        TimeZone.setDefault(timeZone);
    }

    protected static int findFirstDigit(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            return i;
        }
        return -1;
    }

    protected static int toInt(String string, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = string.length();
        n4 = n4 < n5 ? n4 : n5;
        block11: for (int i = n; i < n4; ++i) {
            n3 *= 10;
            switch (string.charAt(i)) {
                case '1': {
                    ++n3;
                    continue block11;
                }
                case '2': {
                    n3 += 2;
                    continue block11;
                }
                case '3': {
                    n3 += 3;
                    continue block11;
                }
                case '4': {
                    n3 += 4;
                    continue block11;
                }
                case '5': {
                    n3 += 5;
                    continue block11;
                }
                case '6': {
                    n3 += 6;
                    continue block11;
                }
                case '7': {
                    n3 += 7;
                    continue block11;
                }
                case '8': {
                    n3 += 8;
                    continue block11;
                }
                case '9': {
                    n3 += 9;
                    continue block11;
                }
            }
        }
        return n3;
    }
}

