/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.datergf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;

public class DateRGF
implements Cloneable,
Comparable,
Serializable {
    public static String version = "92.20060101";
    private static int weekStart = 1;
    public static char dateSeparator = (char)45;
    private static byte dateOrder = (byte)-1;
    private static String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] dayNames = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static DateRGF defaultEpochDate = null;
    private static int defaultEpochFlag = 0;
    private static final DateRGF[] epochDates = new DateRGF[]{null, null, null, null, null};
    private static DateRGF stGC = new DateRGF();
    protected transient int year;
    protected transient int month;
    protected transient int day;
    protected transient int jdn;

    public DateRGF() {
        this.year = 1;
        this.month = 1;
        this.day = 1;
        this.jdn = 1721424;
    }

    public DateRGF(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public static DateRGF valueOf(int n, int n2) {
        DateRGF dateRGF = null;
        if (n > 0 || n == -1) {
            if (n == -1) {
                n = n2;
                n2 = 0;
            }
            dateRGF = new DateRGF();
            dateRGF.year = n / 10000;
            int n3 = n % 10000;
            dateRGF.month = n3 / 100;
            dateRGF.day = n3 % 100;
            dateRGF.jdn = -5000005;
            dateRGF.cD();
        } else {
            dateRGF = n == defaultEpochFlag ? DateRGF.getDefaultEpochDate() : (DateRGF)DateRGF.gED(n).clone();
        }
        if (n2 != 0) {
            dateRGF.add(n2);
        }
        return dateRGF;
    }

    public static DateRGF valueOf(String string) {
        int n;
        int n2;
        int n3;
        String string2 = "";
        DateRGF dateRGF = new DateRGF();
        for (int i = 0; i < string.length() && string2.length() < 8; ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            string2 = string2 + c;
        }
        if (string2.length() != 6 && string2.length() != 8) {
            return null;
        }
        int n4 = Integer.parseInt(string2);
        if (string2.length() == 6) {
            int n5 = n4 / 10000;
            int n6 = (n4 %= 10000) / 100;
            int n7 = n4 % 100;
            switch (dateOrder) {
                case -3: {
                    return dateRGF.set(n7 + 2000, n6, n5);
                }
                case -2: {
                    return dateRGF.set(n7 + 2000, n5, n6);
                }
            }
            return dateRGF.set(n5 + 2000, n6, n7);
        }
        switch (dateOrder) {
            case -3: {
                n3 = n4 / 1000000;
                n2 = (n4 %= 1000000) / 10000;
                n = n4 % 10000;
                break;
            }
            case -2: {
                n2 = n4 / 1000000;
                n3 = (n4 %= 1000000) / 10000;
                n = n4 % 10000;
                break;
            }
            default: {
                return DateRGF.valueOf(-1, n4);
            }
        }
        return dateRGF.set(n, n2, n3);
    }

    public DateRGF add(int n) {
        if (n == 0) {
            return this;
        }
        return DateRGF.jdn2date(this.jdn + n, this);
    }

    public int subtract(DateRGF dateRGF) {
        return this.get(-203) - dateRGF.get(-203);
    }

    public DateRGF assign(DateRGF dateRGF) {
        this.year = dateRGF.year;
        this.month = dateRGF.month;
        this.day = dateRGF.day;
        this.jdn = dateRGF.jdn;
        return this;
    }

    protected void cD() {
        if (this.jdn != -5000005) {
            return;
        }
        if (this.year < 0) {
            this.year = -this.year;
        }
        if (this.month < 0) {
            this.month = -this.month;
        }
        if (this.day < 0) {
            this.day = -this.day;
        }
        DateRGF.jdn2date(this.get(-203), this);
    }

    public int compareTo(Object object) {
        int n = ((DateRGF)object).get(-203);
        int n2 = this.get(-203);
        if (n2 < n) {
            return -1;
        }
        if (n2 == n) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        DateRGF dateRGF = new DateRGF();
        dateRGF.assign(this);
        return dateRGF;
    }

    public boolean equals(DateRGF dateRGF) {
        return this.year == dateRGF.year && this.month == dateRGF.month && this.day == dateRGF.day;
    }

    public int get(int n) {
        switch (n) {
            case -203: {
                if (this.jdn == -5000005) {
                    this.jdn = DateRGF.date2jdn(this);
                }
                return this.jdn;
            }
            case -281: {
                return DateRGF.dow(this);
            }
            case -282: {
                return DateRGF.dow_ord(this);
            }
            case -200: {
                return this.year;
            }
            case -201: {
                return this.month;
            }
            case -202: {
                return this.day;
            }
            case -340: {
                return weekStart;
            }
            case -336: {
                return DateRGF.toJulianDate(this);
            }
            case -290: {
                return DateRGF.isoWeek(this);
            }
            case -303: {
                return DateRGF.daysInMonth(this);
            }
            case -320: {
                return this.month < 7 ? 1 : 2;
            }
            case -310: {
                return this.month < 4 ? 1 : (this.month < 7 ? 2 : (this.month < 10 ? 3 : 4));
            }
            case -219: 
            case -214: 
            case -213: 
            case -212: 
            case -211: 
            case -210: {
                return this.subtract(DateRGF.gED(n));
            }
            case -1: {
                return this.year * 10000 + this.month * 100 + this.day;
            }
        }
        return -1;
    }

    public DateRGF set(int n, int n2) {
        switch (n) {
            case -202: 
            case -201: 
            case -200: 
            case -1: {
                if (n2 < 0) {
                    n2 = -n2;
                }
                switch (n) {
                    case -200: {
                        this.year = n2;
                        break;
                    }
                    case -201: {
                        this.month = n2;
                        break;
                    }
                    case -202: {
                        this.day = n2;
                        break;
                    }
                    case -1: {
                        this.year = n2 / 10000;
                        int n3 = n2 % 10000;
                        this.month = n3 / 100;
                        this.day = n3 % 100;
                    }
                }
                this.jdn = -5000005;
                this.cD();
                return this;
            }
            case -340: {
                if (n2 > 0 && n2 < 8) {
                    weekStart = n2;
                }
                return this;
            }
            case -293: {
                return DateRGF.setGivenWeekday(n2, this);
            }
            case -332: 
            case -331: 
            case -322: 
            case -321: 
            case -312: 
            case -311: 
            case -301: 
            case -300: 
            case -292: 
            case -291: {
                DateRGF dateRGF = null;
                switch (n) {
                    case -292: 
                    case -291: {
                        int n4 = weekStart - DateRGF.dow(this);
                        if (n4 > 0) {
                            n4 -= 7;
                        }
                        n2 += n4;
                        if (n == -292) {
                            n2 += 6;
                        }
                        if (n2 != 0) {
                            this.add(n2);
                        }
                        return this;
                    }
                    case -300: {
                        dateRGF = new DateRGF(this.year, this.month, 1);
                        break;
                    }
                    case -321: {
                        dateRGF = new DateRGF(this.year, this.get(-320) == 1 ? 1 : 7, 1);
                        break;
                    }
                    case -322: {
                        dateRGF = new DateRGF(this.year, this.get(-320) == 1 ? 6 : 12, 1);
                        break;
                    }
                    case -311: {
                        int n5 = this.get(-310);
                        dateRGF = new DateRGF(this.year, n5 == 1 ? 1 : (n5 == 2 ? 4 : (n5 == 3 ? 7 : 10)), 1);
                        break;
                    }
                    case -312: {
                        int n6 = this.get(-310);
                        dateRGF = new DateRGF(this.year, n6 == 1 ? 3 : (n6 == 2 ? 6 : (n6 == 3 ? 9 : 12)), 1);
                        break;
                    }
                    case -331: {
                        dateRGF = new DateRGF(this.year, 1, 1);
                        break;
                    }
                    case -332: {
                        dateRGF = new DateRGF(this.year, 12, 31);
                        break;
                    }
                }
                switch (n) {
                    case -322: 
                    case -312: 
                    case -301: {
                        dateRGF.day = dateRGF.get(-303);
                    }
                }
                dateRGF.jdn = -5000005;
                dateRGF.cD();
                if (n2 != 0) {
                    dateRGF.add(n2);
                }
                this.assign(dateRGF);
                return this;
            }
        }
        return this;
    }

    public static int getStatic(int n) {
        switch (n) {
            case -340: {
                return weekStart;
            }
            case -5: {
                return dateOrder;
            }
        }
        return -1;
    }

    public static int setStatic(int n, int n2) {
        switch (n) {
            case -340: {
                if (n2 < 0 || n2 > 7) {
                    return weekStart;
                }
                weekStart = n2;
                return n2;
            }
            case -5: {
                switch (n2) {
                    case -1: {
                        dateOrder = (byte)-1;
                        break;
                    }
                    case -3: {
                        dateOrder = (byte)-3;
                        break;
                    }
                    case -2: {
                        dateOrder = (byte)-2;
                    }
                }
                return dateOrder;
            }
        }
        return -1;
    }

    public DateRGF set(int n, int n2, int n3) {
        this.year = n < 0 ? -n : n;
        this.month = n2 < 0 ? -n2 : n2;
        this.day = n3 < 0 ? -n3 : n3;
        this.jdn = DateRGF.date2jdn(this);
        DateRGF.jdn2date(this.jdn, this);
        return this;
    }

    public String toString() {
        switch (dateOrder) {
            case -3: {
                return DateRGF.ri(this.day, 2) + dateSeparator + DateRGF.ri(this.month, 2) + dateSeparator + DateRGF.ri(this.year, 4);
            }
            case -2: {
                return DateRGF.ri(this.month, 2) + dateSeparator + DateRGF.ri(this.day, 2) + dateSeparator + DateRGF.ri(this.year, 4);
            }
        }
        return DateRGF.ri(this.year, 4) + dateSeparator + DateRGF.ri(this.month, 2) + dateSeparator + DateRGF.ri(this.day, 2);
    }

    protected static String ri(int n, int n2) {
        String string = "000000";
        String string2 = "" + n;
        if ((n2 -= string2.length()) > 0) {
            return string.substring(0, n2) + string2;
        }
        return string2;
    }

    public static int dow(DateRGF dateRGF) {
        return dateRGF.get(-203) % 7 + 1;
    }

    public static int dow_ord(DateRGF dateRGF) {
        int n = DateRGF.dow(dateRGF) - weekStart + 1;
        if (n < 1) {
            n += 7;
        }
        return n;
    }

    public static DateRGF setGivenWeekday(int n, DateRGF dateRGF) {
        boolean bl = true;
        String string = "" + dateRGF.get(-281);
        char c = string.charAt(0);
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 7;
        if (n < 0) {
            n = -n;
            bl = false;
        }
        String string2 = "" + n;
        for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 < '1' && c2 > '7' || c2 == c) continue;
            n2 = c2 - c;
            if (bl) {
                if (n2 < 0) {
                    n2 += 7;
                }
            } else {
                if (n2 > 0) {
                    n2 -= 7;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            if (n2 >= n3) continue;
            n3 = n2;
        }
        if (!bl) {
            n3 = -n3;
        }
        dateRGF.add(n3);
        return dateRGF;
    }

    public static int date2jdn(DateRGF dateRGF) {
        if (dateRGF.year < DateRGF.stGC.year || dateRGF.year == DateRGF.stGC.year && (dateRGF.month < DateRGF.stGC.month || dateRGF.month == DateRGF.stGC.month && dateRGF.day < DateRGF.stGC.day)) {
            return DateRGF.date2jdn(dateRGF.year, dateRGF.month, dateRGF.day, -336);
        }
        return DateRGF.date2jdn(dateRGF.year, dateRGF.month, dateRGF.day, -335);
    }

    public static int date2jdn(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = (14 - n2) / 12;
        int n6 = n + 4800 - n5;
        int n7 = n2 + 12 * n5 - 3;
        return n3 + (153 * n7 + 2) / 5 + 365 * n6 + (n4 == -335 ? n6 / 4 - n6 / 100 + n6 / 400 - 32045 : n6 / 4 - 32083);
    }

    public static DateRGF jdn2date(int n, DateRGF dateRGF) {
        if (n < DateRGF.stGC.jdn) {
            return DateRGF.jdn2date(n, dateRGF, -336);
        }
        return DateRGF.jdn2date(n, dateRGF, -335);
    }

    public static DateRGF jdn2date(int n, DateRGF dateRGF, int n2) {
        int n3;
        int n4 = 0;
        if (n2 == -335) {
            int n5 = n + 32044;
            n4 = (4 * n5 + 3) / 146097;
            n3 = n5 - 146097 * n4 / 4;
        } else {
            n3 = n + 32082;
        }
        int n6 = (4 * n3 + 3) / 1461;
        int n7 = n3 - 1461 * n6 / 4;
        int n8 = (5 * n7 + 2) / 153;
        int n9 = n8 / 10;
        dateRGF.year = n4 == 0 ? n6 - 4800 + n9 : 100 * n4 + n6 - 4800 + n9;
        dateRGF.month = n8 + 3 - 12 * n9;
        dateRGF.day = n7 - (153 * n8 + 2) / 5 + 1;
        dateRGF.jdn = n;
        return dateRGF;
    }

    public static boolean isLeapYear(DateRGF dateRGF) {
        return new DateRGF((int)dateRGF.year, (int)3, (int)0).day == 29;
    }

    public static int daysInMonth(DateRGF dateRGF) {
        return new DateRGF((int)dateRGF.year, (int)(dateRGF.month + 1), (int)0).jdn - new DateRGF((int)dateRGF.year, (int)dateRGF.month, (int)0).jdn;
    }

    public static int toJulianDate(DateRGF dateRGF) {
        return dateRGF.year * 1000 + (dateRGF.jdn - new DateRGF((int)(dateRGF.year - 1), (int)12, (int)31).jdn);
    }

    public static DateRGF fromJulianDate(int n) {
        DateRGF dateRGF = new DateRGF(n / 1000 - 1, 12, 31);
        dateRGF.add(n % 1000);
        return dateRGF;
    }

    public static int isoWeek(DateRGF dateRGF) {
        DateRGF dateRGF2 = new DateRGF(dateRGF.year, 1, 1);
        int n = DateRGF.dow(dateRGF2);
        int n2 = DateRGF.dow(dateRGF2) > 4 ? n - 9 : n - 2;
        int n3 = (dateRGF.get(-203) - dateRGF2.get(-203) + 1 + n2) / 7 + 1;
        if (n3 > 51) {
            n = DateRGF.dow(new DateRGF(dateRGF.year, 12, 31));
            if (n < 4 && dateRGF.day > 31 - n) {
                n3 = 1;
            }
        } else if (n3 == 1 && dateRGF.day + n2 < 0) {
            dateRGF2 = new DateRGF(dateRGF.year - 1, 1, 1);
            n2 = DateRGF.dow(dateRGF2) > 4 ? n - 9 : n - 2;
            n3 = (DateRGF.date2jdn(new DateRGF(dateRGF.year - 1, 12, 31)) - dateRGF2.get(-203) + 1 + n2) / 7 + 1;
        }
        return n3;
    }

    private static DateRGF gED(int n) {
        if (n == defaultEpochFlag) {
            return defaultEpochDate;
        }
        switch (n) {
            case -212: {
                if (epochDates[0] == null) {
                    DateRGF.epochDates[0] = new DateRGF(1970, 1, 1);
                }
                return epochDates[0];
            }
            case -213: {
                if (epochDates[1] == null) {
                    DateRGF.epochDates[1] = new DateRGF(1980, 1, 1);
                }
                return epochDates[1];
            }
            case -214: {
                if (epochDates[2] == null) {
                    DateRGF.epochDates[2] = new DateRGF(1601, 1, 1);
                }
                return epochDates[2];
            }
            case -211: {
                if (epochDates[3] == null) {
                    DateRGF.epochDates[3] = new DateRGF(1904, 1, 1);
                }
                return epochDates[3];
            }
            case -210: {
                if (epochDates[4] == null) {
                    DateRGF.epochDates[4] = new DateRGF(1858, 11, 17);
                }
                return epochDates[4];
            }
        }
        return DateRGF.getDefaultEpochDate();
    }

    public static DateRGF getDefaultEpochDate() {
        if (defaultEpochDate == null) {
            DateRGF.setDefaultEpochDate(-211);
        }
        return (DateRGF)defaultEpochDate.clone();
    }

    public static DateRGF setDefaultEpochDate(int n) {
        if (defaultEpochFlag != n || n == 0) {
            if (n < 0) {
                switch (n) {
                    case -214: 
                    case -213: 
                    case -212: 
                    case -211: 
                    case -210: {
                        break;
                    }
                    default: {
                        n = -211;
                    }
                }
                defaultEpochDate = DateRGF.gED(n);
                defaultEpochFlag = n;
            } else {
                defaultEpochDate = DateRGF.valueOf(-1, n);
                defaultEpochFlag = -215;
            }
        }
        return (DateRGF)defaultEpochDate.clone();
    }

    public static String getString(int n, int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        switch (n) {
            case -280: {
                return dayNames[n2 % 8 - 1];
            }
            case -302: {
                return monthNames[n2 % 13 - 1];
            }
        }
        return "<DateRGF.getString(): unknown flag '" + n + "'>";
    }

    public static void setString(int n, String[] stringArray) {
        switch (n) {
            case -280: {
                if (stringArray.length == 7) {
                    dayNames = stringArray;
                }
                return;
            }
            case -302: {
                if (stringArray.length == 12) {
                    monthNames = stringArray;
                }
                return;
            }
        }
    }

    public static DateRGF easter(DateRGF dateRGF) {
        if (dateRGF.get(-203) < stGC.get(-203)) {
            return DateRGF.easter(dateRGF.year, -336);
        }
        return DateRGF.easter(dateRGF.year, -335);
    }

    public static DateRGF easter(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        DateRGF dateRGF = new DateRGF();
        int n7 = n % 19;
        if (n2 == -335) {
            n6 = n / 100;
            n5 = n6 / 4;
            int n8 = (n6 - n5 - (8 * n6 + 13) / 25 + 19 * n7 + 15) % 30;
            int n9 = n8 / 28;
            n4 = n8 - n9 * (1 - n9 * (29 / (n8 + 1)) * ((21 - n7) / 11));
            n3 = (n + n / 4 + n4 + 2 - n6 + n5) % 7;
        } else {
            n4 = (19 * n7 + 15) % 30;
            n3 = (n + n / 4 + n4) % 7;
        }
        int n10 = n4 - n3;
        n6 = 3 + (n10 + 40) / 44;
        n5 = n10 + 28 - 31 * (n6 / 4);
        dateRGF.year = n;
        dateRGF.month = n6;
        dateRGF.day = n5;
        dateRGF.jdn = DateRGF.date2jdn(n, n6, n5, n2);
        return dateRGF;
    }

    public static DateRGF getGregorianChange() {
        return (DateRGF)stGC.clone();
    }

    public static DateRGF setGregorianChange(int n, int n2, int n3) {
        DateRGF.stGC.year = n;
        DateRGF.stGC.month = n2;
        DateRGF.stGC.day = n3;
        DateRGF.stGC.jdn = DateRGF.date2jdn(n, n2, n3, -335);
        return (DateRGF)stGC.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.jdn);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DateRGF.jdn2date(objectInputStream.readInt(), this);
    }

    public DateRGF update() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return this.set(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    static {
        DateRGF.setGregorianChange(1582, 10, 15);
        DateRGF.setDefaultEpochDate(-211);
        weekStart = 7;
    }
}

