/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.util.Iterator;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        Object object2 = null;
        try {
            Context context = Context.enter();
            Object object3 = this.global.get(string, this.global);
            if (object3 == Scriptable.NOT_FOUND) {
                throw new EvaluatorException("function " + string + " not found.", "none", 0);
            }
            context.setOptimizationLevel(-1);
            context.setGeneratingDebug(false);
            context.setGeneratingSource(false);
            context.setOptimizationLevel(0);
            context.setDebugger(null, null);
            object2 = ((Function)object3).call(context, this.global, this.global, objectArray);
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).unwrap();
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        finally {
            Context.exit();
        }
        return object2;
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (bSFDeclaredBean.bean instanceof Number || bSFDeclaredBean.bean instanceof String || bSFDeclaredBean.bean instanceof Boolean) {
            this.global.put(bSFDeclaredBean.name, this.global, bSFDeclaredBean.bean);
        } else {
            Scriptable scriptable = Context.toObject((Object)bSFDeclaredBean.bean, (Scriptable)this.global);
            this.global.put(bSFDeclaredBean.name, this.global, (Object)scriptable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        Object object2 = null;
        try {
            Context context = Context.enter();
            context.setOptimizationLevel(-1);
            context.setGeneratingDebug(false);
            context.setGeneratingSource(false);
            context.setOptimizationLevel(0);
            context.setDebugger(null, null);
            object2 = context.evaluateString(this.global, string2, string, n, null);
            if (object2 instanceof NativeJavaObject) {
                object2 = ((NativeJavaObject)object2).unwrap();
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        finally {
            Context.exit();
        }
        return object2;
    }

    private void handleError(Throwable throwable) throws BSFException {
        if (throwable instanceof WrappedException) {
            throwable = ((WrappedException)throwable).getWrappedException();
        }
        String string = null;
        Throwable throwable2 = throwable;
        if (throwable instanceof JavaScriptException) {
            string = throwable.getLocalizedMessage();
            Object object = ((JavaScriptException)throwable).getValue();
            if (object instanceof Throwable) {
                throwable2 = (Throwable)object;
            }
        } else if (throwable instanceof EvaluatorException || throwable instanceof SecurityException) {
            string = throwable.getLocalizedMessage();
        } else if (throwable instanceof RuntimeException) {
            string = "Internal Error: " + throwable.toString();
        } else if (throwable instanceof StackOverflowError) {
            string = "Stack Overflow";
        }
        if (string == null) {
            string = throwable.toString();
        }
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        throw new BSFException(500, "JavaScript Error: " + string, throwable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        try {
            Context context = Context.enter();
            this.global = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject((Object)new BSFFunctions(bSFManager, this), (Scriptable)this.global);
            this.global.put("bsf", this.global, (Object)scriptable);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.declareBean((BSFDeclaredBean)iterator.next());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            Context.exit();
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.global.delete(bSFDeclaredBean.name);
    }
}

