/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test.engineTests;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.test.BSFEngineTestTmpl;

public class javascriptTest
extends BSFEngineTestTmpl {
    private BSFEngine javascriptEngine;
    static /* synthetic */ Class class$java$lang$Double;

    public javascriptTest(String string) {
        super(string);
    }

    public void setUp() {
        super.setUp();
        try {
            this.javascriptEngine = this.bsfManager.loadScriptingEngine("javascript");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("Failure attempting to load Rhino", exception));
        }
    }

    public void testExec() {
        try {
            this.javascriptEngine.exec("Test.js", 0, 0, "java.lang.System.out.print (\"PASSED\");");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("exec() test failed", exception));
        }
        javascriptTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testEval() {
        Double d = null;
        try {
            d = new Double(this.javascriptEngine.eval("Test.js", 0, 0, "1 + 1;").toString());
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("eval() test failed", exception));
        }
        javascriptTest.assertEquals((Object)new Double(2.0), (Object)d);
    }

    public void testCall() {
        Object[] objectArray = new Object[]{new Double(1.0)};
        Double d = null;
        try {
            this.javascriptEngine.exec("Test.js", 0, 0, "function addOne (f) {\n return f + 1;\n}");
            d = new Double(this.javascriptEngine.call(null, "addOne", objectArray).toString());
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("call() test failed", exception));
        }
        javascriptTest.assertEquals((Object)new Double(2.0), d);
    }

    public void testIexec() {
        try {
            this.javascriptEngine.iexec("Test.js", 0, 0, "java.lang.System.out.print (\"PASSED\");");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("iexec() test failed", exception));
        }
        javascriptTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testBSFManagerEval() {
        Double d = null;
        try {
            d = new Double(this.bsfManager.eval("javascript", "Test.js", 0, 0, "1 + 1;").toString());
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("BSFManager eval() test failed", exception));
        }
        javascriptTest.assertEquals((Object)new Double(2.0), (Object)d);
    }

    public void testBSFManagerAvailability() {
        Object object = null;
        try {
            object = this.javascriptEngine.eval("Test.js", 0, 0, "bsf.lookupBean(\"foo\");");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("Test of BSFManager availability failed", exception));
        }
        javascriptTest.assertNull((Object)object);
    }

    public void testRegisterBean() {
        Double d = new Double(1.0);
        Double d2 = null;
        try {
            this.bsfManager.registerBean("foo", d);
            d2 = (Double)this.javascriptEngine.eval("Test.js", 0, 0, "bsf.lookupBean(\"foo\");");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("registerBean() test failed", exception));
        }
        javascriptTest.assertEquals((Object)d, d2);
    }

    public void testUnregisterBean() {
        Double d = new Double(1.0);
        Double d2 = null;
        try {
            this.bsfManager.registerBean("foo", d);
            this.bsfManager.unregisterBean("foo");
            d2 = (Double)this.javascriptEngine.eval("Test.js", 0, 0, "bsf.lookupBean(\"foo\");");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("unregisterBean() test failed", exception));
        }
        javascriptTest.assertNull(d2);
    }

    public void testDeclareBean() {
        Double d = new Double(1.0);
        Double d2 = null;
        try {
            this.bsfManager.declareBean("foo", d, class$java$lang$Double == null ? (class$java$lang$Double = javascriptTest.class$("java.lang.Double")) : class$java$lang$Double);
            d2 = (Double)this.javascriptEngine.eval("Test.js", 0, 0, "foo + 1;");
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("declareBean() test failed", exception));
        }
        javascriptTest.assertEquals((Object)new Double(2.0), d2);
    }

    public void testUndeclareBean() {
        Double d = new Double(1.0);
        Double d2 = null;
        try {
            this.bsfManager.declareBean("foo", d, class$java$lang$Double == null ? (class$java$lang$Double = javascriptTest.class$("java.lang.Double")) : class$java$lang$Double);
            this.bsfManager.undeclareBean("foo");
            d2 = (Double)this.javascriptEngine.eval("Test.js", 0, 0, "foo + 1");
        }
        catch (BSFException bSFException) {
        }
        catch (Exception exception) {
            javascriptTest.fail((String)this.failMessage("undeclareBean() test failed", exception));
        }
        javascriptTest.assertNull(d2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

