/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test.utilTests;

import junit.framework.TestCase;
import org.apache.bsf.BSFException;
import org.apache.bsf.test.utilTests.TestBean;
import org.apache.bsf.util.EngineUtils;

public class EngineUtilsTest
extends TestCase {
    Object result = null;

    public EngineUtilsTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCallBeanMethod() {
        Object[] objectArray = new Object[]{new String("MoreConfirmation")};
        TestBean testBean = new TestBean("TestBean");
        try {
            this.result = EngineUtils.callBeanMethod(testBean, "getStringValue", null);
        }
        catch (BSFException bSFException) {
            EngineUtilsTest.fail((String)("createBean method failed" + bSFException));
        }
        EngineUtilsTest.assertEquals((String)"TestBean", (String)((String)this.result));
        try {
            EngineUtils.callBeanMethod(testBean, "setValue", objectArray);
        }
        catch (BSFException bSFException) {
            EngineUtilsTest.fail((String)("createBean method failed" + bSFException));
        }
        EngineUtilsTest.assertEquals((String)"MoreConfirmation", (String)testBean.getStringValue());
        objectArray = new Object[]{new String("aString"), new Integer(1)};
        try {
            EngineUtils.callBeanMethod(testBean, "setValue", objectArray);
        }
        catch (BSFException bSFException) {
            EngineUtilsTest.fail((String)("createBean method failed" + bSFException));
        }
        EngineUtilsTest.assertEquals((String)"aString", (String)testBean.getStringValue());
        EngineUtilsTest.assertEquals((Object)new Integer(1), (Object)((Integer)testBean.getNumericValue()));
        try {
            this.result = EngineUtils.callBeanMethod(testBean, "nonExistentMethod", objectArray);
            EngineUtilsTest.fail();
        }
        catch (BSFException bSFException) {
            // empty catch block
        }
    }

    public void testCreateBean() throws BSFException {
        Object[] objectArray = new Object[]{new String("test")};
        try {
            this.result = EngineUtils.createBean("org.apache.bsf.test.utilTests.TestBean", objectArray);
        }
        catch (BSFException bSFException) {
            EngineUtilsTest.fail((String)("createBean method failed" + bSFException));
        }
        EngineUtilsTest.assertNotNull((Object)this.result);
        EngineUtilsTest.assertEquals((String)"test", (String)((TestBean)this.result).getStringValue());
        try {
            Object object = EngineUtils.createBean("nonExsitentClass", null);
            EngineUtilsTest.fail();
        }
        catch (BSFException bSFException) {
            // empty catch block
        }
    }

    public void testGetTypeSignatureString() {
        Integer n = new Integer(10);
        String string = EngineUtils.getTypeSignatureString(n.getClass());
        EngineUtilsTest.assertEquals((String)"Ljava/lang/Integer;", (String)string);
        EngineUtilsTest.assertEquals((String)"I", (String)EngineUtils.getTypeSignatureString(Integer.TYPE));
    }
}

