/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.Bean;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.event.EventAdapter;
import org.apache.bsf.util.event.EventAdapterRegistry;
import org.apache.bsf.util.event.EventProcessor;
import org.apache.bsf.util.type.TypeConvertor;
import org.apache.bsf.util.type.TypeConvertorRegistry;

public class ReflectionUtils {
    static ClassLoader bsfManagerDefinedCL = BSFManager.getDefinedClassLoader();

    public static void addEventListener(Object object, String string, EventProcessor eventProcessor) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] objectArray;
        Method method;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        FeatureDescriptor[] featureDescriptorArray = beanInfo.getEventSetDescriptors();
        EventSetDescriptor eventSetDescriptor = (EventSetDescriptor)ReflectionUtils.findFeatureByName("event", string, featureDescriptorArray);
        if (eventSetDescriptor == null) {
            String string2 = "event set '" + string + "' unknown for source type '" + object.getClass() + "': ";
            if (featureDescriptorArray.length == 0) {
                string2 = string2 + "class does not implement any event methods following Java's event pattern!";
            } else {
                string2 = string2 + "class defines the following event set(s): ";
                TreeSet<FeatureDescriptor> treeSet = new TreeSet<FeatureDescriptor>(new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((EventSetDescriptor)object).getName().compareToIgnoreCase(((EventSetDescriptor)object2).getName());
                    }

                    public boolean equals(Object object, Object object2) {
                        return ((EventSetDescriptor)object).getName().equalsIgnoreCase(((EventSetDescriptor)object2).getName());
                    }
                });
                for (int i = 0; i < featureDescriptorArray.length; ++i) {
                    treeSet.add(featureDescriptorArray[i]);
                }
                Iterator iterator = treeSet.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    EventSetDescriptor eventSetDescriptor2 = (EventSetDescriptor)iterator.next();
                    if (n > 0) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + "\n\t" + '\'' + eventSetDescriptor2.getName() + "'={";
                    Method[] methodArray = eventSetDescriptor2.getListenerMethods();
                    TreeSet<Method> treeSet2 = new TreeSet<Method>(new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((Method)object).getName().compareToIgnoreCase(((Method)object2).getName());
                        }

                        public boolean equals(Object object, Object object2) {
                            return ((Method)object).getName().equalsIgnoreCase(((Method)object2).getName());
                        }
                    });
                    for (int i = 0; i < methodArray.length; ++i) {
                        treeSet2.add(methodArray[i]);
                    }
                    Iterator iterator2 = treeSet2.iterator();
                    int n2 = 0;
                    while (iterator2.hasNext()) {
                        if (n2 > 0) {
                            string2 = string2 + ',';
                        }
                        string2 = string2 + '\'' + ((Method)iterator2.next()).getName() + '\'';
                        ++n2;
                    }
                    string2 = string2 + '}';
                    ++n;
                }
                string2 = string2 + ".";
            }
            throw new IllegalArgumentException(string2);
        }
        Class<?> clazz = eventSetDescriptor.getListenerType();
        Class clazz2 = EventAdapterRegistry.lookup(clazz);
        if (clazz2 == null) {
            throw new IllegalArgumentException("event adapter for listener type '" + clazz + "' (eventset " + "'" + string + "') unknown");
        }
        EventAdapter eventAdapter = (EventAdapter)clazz2.newInstance();
        eventAdapter.setEventProcessor(eventProcessor);
        if (string.equals("propertyChange") || string.equals("vetoableChange")) {
            method = eventSetDescriptor.getAddListenerMethod();
            objectArray = new Object[]{eventAdapter};
        } else {
            method = eventSetDescriptor.getAddListenerMethod();
            objectArray = new Object[]{eventAdapter};
        }
        method.invoke(object, objectArray);
    }

    public static Bean createBean(ClassLoader classLoader, String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (classArray != null) {
            Class<?> clazz = null;
            ClassNotFoundException classNotFoundException = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    classNotFoundException = classNotFoundException2;
                }
            }
            if (clazz == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                if (classLoader != bsfManagerDefinedCL) {
                    clazz = bsfManagerDefinedCL.loadClass(string);
                } else {
                    throw classNotFoundException;
                }
            }
            Constructor constructor = MethodUtils.getConstructor(clazz, classArray);
            return new Bean(clazz, constructor.newInstance(objectArray));
        }
        Object object = Beans.instantiate(classLoader, string);
        return new Bean(object.getClass(), object);
    }

    public static Bean createBean(ClassLoader classLoader, String string, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : null;
            }
        }
        return ReflectionUtils.createBean(classLoader, string, classArray, objectArray);
    }

    private static FeatureDescriptor findFeatureByName(String string, String string2, FeatureDescriptor[] featureDescriptorArray) {
        for (int i = 0; i < featureDescriptorArray.length; ++i) {
            if (!string2.equals(featureDescriptorArray[i].getName())) continue;
            return featureDescriptorArray[i];
        }
        return null;
    }

    private static String getEventSetNameInfos(FeatureDescriptor[] featureDescriptorArray) {
        if (featureDescriptorArray.length == 0) {
            return "Impossible to create an event adapter, because no methods following the event listener pattern could be found!";
        }
        String string = "";
        for (int i = 0; i < featureDescriptorArray.length; ++i) {
        }
        return null;
    }

    public static Bean getField(Object object, String string) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            Object object2 = field.get(object);
            return new Bean(clazz2, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + string + "' is " + "unknown for '" + object + "'");
        }
    }

    public static Bean getProperty(Object object, String string, Integer n) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz;
        Method method;
        Object object2;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", string, beanInfo.getPropertyDescriptors());
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("property '" + string + "' is " + "unknown for '" + object + "'");
        }
        if (n != null) {
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to get non-indexed property '" + string + "' as being indexed");
            }
            object2 = (IndexedPropertyDescriptor)propertyDescriptor;
            method = ((IndexedPropertyDescriptor)object2).getIndexedReadMethod();
            clazz = ((IndexedPropertyDescriptor)object2).getIndexedPropertyType();
        } else {
            method = propertyDescriptor.getReadMethod();
            clazz = propertyDescriptor.getPropertyType();
        }
        if (method == null) {
            throw new IllegalArgumentException("property '" + string + "' is not readable");
        }
        object2 = null;
        object2 = n != null ? method.invoke(object, n) : method.invoke(object, null);
        return new Bean(clazz, object2);
    }

    public static void setField(Object object, String string, Bean bean, TypeConvertorRegistry typeConvertorRegistry) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            Object object2 = null;
            boolean bl = true;
            if (clazz2.isAssignableFrom(bean.type)) {
                object2 = bean.value;
            } else if (typeConvertorRegistry != null) {
                TypeConvertor typeConvertor = typeConvertorRegistry.lookup(bean.type, clazz2);
                if (typeConvertor != null) {
                    object2 = typeConvertor.convert(bean.type, clazz2, bean.value);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("unable to assign '" + bean.value + "' to field '" + string + "'");
            }
            field.set(object, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + string + "' is " + "unknown for '" + object + "'");
        }
    }

    public static void setProperty(Object object, String string, Integer n, Object object2, Class clazz, TypeConvertorRegistry typeConvertorRegistry) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz2;
        Method method;
        Object object3;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", string, beanInfo.getPropertyDescriptors());
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("property '" + string + "' is " + "unknown for '" + object + "'");
        }
        if (n != null) {
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to set non-indexed property '" + string + "' as being indexed");
            }
            object3 = (IndexedPropertyDescriptor)propertyDescriptor;
            method = ((IndexedPropertyDescriptor)object3).getIndexedWriteMethod();
            clazz2 = ((IndexedPropertyDescriptor)object3).getIndexedPropertyType();
        } else {
            method = propertyDescriptor.getWriteMethod();
            clazz2 = propertyDescriptor.getPropertyType();
        }
        if (method == null) {
            throw new IllegalArgumentException("property '" + string + "' is not writeable");
        }
        object3 = null;
        boolean bl = true;
        if (clazz2.isAssignableFrom(clazz)) {
            object3 = object2;
        } else if (typeConvertorRegistry != null) {
            TypeConvertor typeConvertor = typeConvertorRegistry.lookup(clazz, clazz2);
            if (typeConvertor != null) {
                object3 = typeConvertor.convert(clazz, clazz2, object2);
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            throw new IllegalArgumentException("unable to assign '" + object2 + "' to property '" + string + "'");
        }
        if (n != null) {
            method.invoke(object, n, object3);
        } else {
            method.invoke(object, object3);
        }
    }
}

