/* Hello World in ooRexx, cf. http://www.ooRexx.org, version: 2008-06-24, Rony G. Flatscher

      This is an ooRexx template script: just delete everything you do not need from
      it and then add your own code.

      This template can can be executed as a macro for any document. It demonstrates how to:

         - get at the document object, the desktop object and the ComponentContext object
           as supplied by OOo for this macro invocation, and

         - determine the document type for which the macro was activated and how to interact
           with a text and a spreadsheet document.

         - use the ooRexx supplied condition (exception) information, just uncomment the
           very first statement after this comment (remove the two '--' at the beginning)
*/
-- signal on syntax /* uncomment, if condition/exceptions should be displayed in a popup dialog */

scriptContext=uno.getScriptContext()         /* get the xScriptContext object                   */
oDoc=scriptContext~getDocument               /* get the document service (a XModel) object      */
/*
xDesktop=scriptContext~getDesktop            /* get the desktop (a XDesktop) object             */
xContext=scriptContext~getComponentContext   /* get the context (a XComponentContext) object    */
*/

      /* replace the following part with your code (begin) ==>          */
      /* demonstration of how to interact with different document types */

      /* define some text:                                              */
str="Hello world ["date("s") time()"], this is ooRexx (cf. <http://www.ooRexx.org>) speaking ! "

if oDoc~uno.queryServiceName("TextDocument")<>"" then    /* a TextDcoument in hand?             */
do
   xTextDoc=oDoc~XTextDocument               /* get the XTextDocument interface                 */
   xTextDoc~getText~getEnd~setString(str)    /* add text at the end of the text document        */
end
else if oDoc~uno.queryServiceName("SpreadsheetDocument")<>"" then /* a SpreadsheetDocument?     */
do
   xSheet = oDoc~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0)~XSpreadSheet
   cell=uno.getCell(xSheet, "A1")            /* get cell object                                 */
   -- or: cell=uno.getCell(xSheet, 0, 0)     /* co-ordinates as 0-based numbers                 */
   text=cell~getFormula                      /* get unedited text                               */
   -- or: text=cell~XText~getString          /* use the XText interface method "getString"      */

   if text<>"" then str=text str             /* add "str" to existing text                      */

   call uno.setCell xSheet, "A1", str        /* set the text in the cell                        */
   -- or: call uno.setCell xSheet, 0, 0, str /* co-ordinates as 0-based numbers                 */
end
else  /* an unknown document type, display its implemented service(s)   */
do
   LF="0a"x                                  /* LF (line-feed) character                        */
   hint="- "                                 /* define a hint string (a dash and a blank)       */

   url=oDoc~getUrl                           /* get Document's name (an URL)                    */
   if url<>"" then str=str LF || "Document URL/Name:" url LF LF
   str=str LF LF "Implemented services:"
      /* get blank delimited service names, prepend blank, then change blank to LF and the hint:*/
   str=str LF || (" "oDoc~uno.getServiceNames)~changestr(" ", LF || hint) LF

   title="Unknown Document Type Implementing the Following Service(s)"
   .bsf.dialog~messageBox(str, title, "information")
end
      /* <== replace the previous part with your code (end)   */
return


/* this is a sample of how one could exploit ooRexx and BSF4Rexx error information */
syntax:    /* create and display condition/exception information in a popup dialog */
   co=condition("O")    -- get condition object, describing the condition/exception
   LF="0a"x             -- the line-feed character
   TAB="        "       -- blanks simulating a tab character

   tmpStr=""            -- set to empty string
   do idx over co~makeArray~sort /* sort the directory indexes and iterate over them */
      val=co[idx]       -- get the associated value from the condition object (a directory)
      tmpStr=tmpStr || (idx || ":")~left(25) pp(val) LF

      if val~hasmethod("items") then   -- a collection? show its content
      do item over val
         tmpStr=tmpStr || tab || tab || pp(item) || LF
      end
   end

   if length(tmpStr)>750 then tmpStr=left(tmpStr,750)"..." -- show only the first 750 chars

   /* Are there any Java error messages/stack traces available, if so, show them */
   if var("BSF_ERROR_MESSAGE") | .local~hasEntry("BSF_ERROR_MESSAGE") then -- a BSF error message ?
   do
      if var("BSF_ERROR_MESSAGE") then errStr=BSF_ERROR_MESSAGE   -- variable from this scope
                                  else errStr=.bsf_error_message  -- value from .local environment

      tmpStr=tmpStr LF LF || "-"~copies(80) LF   -- extend the string
      tmpStr=tmpStr          "*** BSF4Rexx Error Information: ***" LF LF
      if length(errStr)>1000 then
         tmpStr=tmpStr || left(errStr,1000)"..."
      else
         tmpStr=tmpStr || errStr
   end

   -- if invoked from the macro editor, then show/point to error line
   scriptModel=uno.getScriptSourceModel()
   if scriptModel<>.nil then scriptModel~indicateErrorLine(co~position)

   .bsf.dialog~messageBox(tmpStr, "Runtime error #" co~code, "error") -- display the string


::requires UNO.CLS   /* load UNO support (OpenOffice/StarOffice) for ooRexx   */


