#!/usr/bin/rexx
/* ---rgf, 2003-03-10, 2003-03-05, 2003-04-16, 2003-04-22 , 2003-06-01, 2005-11-06
           2006-12-13
   tests the BSF4Rexx installation, queries all version information;
   can be invoked directly or via Java, e.g. "rexxj BSF4Rexx_info2html.rex"

   author:  Rony G. Flatscher
   date:    2006-12-13
   purpose: create a HTML-rendering containing the settings in effect for BSF4Rexx
   usage:  bsf4rexx  BSF4Rexx_info2html > bsf4rexx_config.html
             or
           rexx  BSF4Rexx_info2html > bsf4rexx_config.html
             or
           rexxj BSF4Rexx_info2html > bsf4rexx_config.html

   license:

   ------------------------ Apache Version 2.0 license -------------------------
      Copyright 2006-2008 Rony G. Flatscher

      Licensed under the Apache License, Version 2.0 (the "License");
      you may not use this file except in compliance with the License.
      You may obtain a copy of the License at

          http://www.apache.org/licenses/LICENSE-2.0

      Unless required by applicable law or agreed to in writing, software
      distributed under the License is distributed on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      See the License for the specific language governing permissions and
      limitations under the License.
   -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") = 1 then   /* BSF() support not loaded yet ? */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs
   call BsfLoadJava
end

crlf="0d0a"x         /* CR-LF character      */
tab="09"x            /* TAB character        */
tmp=    "<table border cellpadding='3px' width='100%'>" crlf
tmp=tmp "<tr><th colspan='2' width='100%'>" "BSF4Rexx Installation Information" "(as of:" date("s") time()")" crlf crlf
tmp=tmp "</table>" crlf
tmp=tmp crlf "<p>" crlf


parse version version
tmp=tmp "<table border cellpadding='3px' align='center'>" crlf
tmp=tmp crlf crlf "<tr><th colspan='2'> Information on BSF4Rexx"
tmp=tmp tab "<tr><th style='text-align: left;'>" 'Rexx interpreter: ' "<td>" pp(version)         crlf

tmp=tmp tab "<tr><th style='text-align: left;'>" 'BSF4Rexx (DLL/so):' "<td>" pp(bsfVersion())    crlf
tmp=tmp tab "<tr><th style='text-align: left;'>" 'Java Rexx engine: ' "<td>" pp(bsf("version"))  crlf crlf

versions=bsf('version', 'all')      -- get all version information
if versions<>"" then
do
   tmp = tmp tab "<tr><th style='text-align: left;'> BSF('version', 'all'): <td>"
   tmp2= tab tab "<table>" crlf
   do while versions<>""
      parse var versions clazz ver versions
      tmp2=tmp2 tab tab tab "<tr>" "<td>" clazz "<td>" ver crlf
   end
   tmp2= tmp2 tab tab "</table>" crlf
   tmp = tmp tmp2 crlf crlf
end


text="by Rexx which loaded Java"
if BsfInvokedBy()=1 then text="via Java"
tmp=tmp tab "<tr><th style='text-align: left;'>" "Rexx script invocation:"
tmp=tmp "<td>" "<em>" pp(text) "</em>" "<hr>" crlf crlf

   call BsfQueryRegisteredFunctions "s."
   tmp=tmp "The following BSF-functions are registered with Rexx:"

   tmp=tmp tab "<ol>" crlf
   do i=1 to s.0
      tmp=tmp tab tab "<li>" pp(s.i) crlf
   end
   tmp=tmp tab "</ol>" crlf
tmp=tmp "</table>" crlf crlf "<p>"


   /* Java infos  */
path_separator =bsf('invoke', 'System.class', 'getProperty', 'path.separator' )
ps_length=length(path_separator)
call java_props      /* read and sort all available Java properties     */

tmp=tmp "<table border cellpadding='3px' align='center'>" crlf
tmp=tmp "<tr><th colspan='3'> Information on Java"

do i=1 to jprops.0
   parse var jprops.i . (tab) key (tab) value
   bPath=0
   if length(value)>ps_length then        /* if more chars than path separator available  */
     bPath=pos(path_separator, value)>1   /* if path separator, then break up value       */

   if bPath then
      tmp=tmp tab break_up2(i, key, value, path_separator) crlf
   else
      tmp=tmp tab make_tr2(i, key, value) crlf
end

/*
   /* show the Java version in use for this invocation */
str="os.name os.version os.arch"
str=str "java.specification.version java.version"                     ,
        "java.compiler java.vm.vendor java.vm.info java.vm.version"   ,
        "java.vm.specification.vendor"  ,
        "java.vm.specification.version java.vm.specification.name"            ,
        "path.separator file.separator file.encoding"                 ,
        "java.home java.io.tmpdir user.dir"

do i=1 to words(str)
   tmp=tmp tab make_tr( word(str, i) ) crlf
end


path_separator =bsf('invoke', 'System.class', 'getProperty', 'path.separator' )

str="java.ext.dirs  java.class.path java.library.path sun.boot.class.path sun.boot.library.path"
do i=1 to words(str)
   tmp=tmp tab break_up(word(str, i), path_separator) crlf
end
*/

tmp=tmp "</table>" crlf

say tmp
exit

pp: procedure
   tag="kbd"
   return "<"tag">"arg(1)"</"tag">"

/*
break_up: procedure expose crlf tab /* break up path */
   parse arg key, separator
   path=bsf('invoke', 'System.class', 'getProperty', key)

   tmp=""
   do while path <> ""
      if pos(separator, path) > 0 then trailer=separator
                                  else trailer=""
      parse var path junk (separator) path
      tmp=tmp tab tab tab "["pp(junk)"]" trailer
      if path <> "" then tmp=tmp "<br>"
      tmp=tmp crlf
   end
   return "<tr><th style='text-align:right;' width='30%'>" key "<td>" tmp


make_tr: procedure expose crlf tab
   parse arg key
   tmp="<tr><th style='text-align:right;' width='30%'>" key "<td>"
   return tmp pp(bsf('invoke', 'System.class', 'getProperty', key ))
*/


break_up2: procedure expose crlf tab
   parse arg idx, key, path, separator
-- say "break_up2: key="key "path="path "separator="separator
   tmp=""
   do while path <> ""
      if pos(separator, path) > 0 then trailer=separator
                                  else trailer=""
      parse var path junk (separator) path
      tmp=tmp tab tab tab "["pp(junk)"]" trailer
      if path <> "" then tmp=tmp "<br>"
      tmp=tmp crlf
   end
   return "<tr><td style='text-align: right;'>" idx "<th style='text-align:left;' width='30%'>" key "<td>" tmp


make_tr2: procedure expose crlf tab
   parse arg idx, key, value
-- say "make_tr2: key="key "value="value
   return "<tr><td style='text-align: right;'>" idx "<th style='text-align:left;' width='30%'>" key "<td>" value



java_props: procedure expose jprops.
   jprops.=""      /* default value of empty string */
   i=0
   tab="09"x
   ctl_chars=xrange("0"x, "1f"x) || "FF"x /* determine chars which should get escaped  */

   props=bsf('invoke', 'System.class', 'getProperties')  /* get all Java properties */
   prop_names=bsf('invoke', props, 'propertyNames')      /* get all property names  */

      /* wrap the Enumeration object, so Java 1.1 can handle this too (overcome Java inner class access restriction) */
      /* the following statement is *not* necessary for Java >= 1.2 */
   prop_names=bsf('wrapEnumeration', prop_names)

   do while bsf('invoke', prop_names, 'hasMoreElements')    /* iterate over keys       */
      i=i+1
      key=bsf('invoke', prop_names, 'nextElement')       /* get next key            */
      val=bsf('invoke', props, 'getProperty', key)       /* get value            */
      -- jprops.i=translate(key) || tab || key || tab || val
      jprops.i=translate(key) || tab || key || tab || decode_ctl_chars(val)
   end
   jprops.0=i     /* save number of elements       */
   call sort_java_props       /* sort the properties  */
   return



decode_ctl_chars: procedure expose ctl_chars
   parse arg val

   tmp=""
   do forever
      pos=verify(val, ctl_chars, "Match")       /* get position of ctl_char in string  */
      if pos=0 then leave
      if pos=1 then
      do
          tmp=tmp || "[0x"||c2x(substr(val, pos, 1))||"]"
      end
      else
      do
          tmp=tmp || substr(val, 1, pos-1) || "[0x"||c2x(substr(val, pos, 1))||"]"
      end
      val=substr(val, pos+1)
   end
   if tmp ="" then return val                   /* no ctl_chars found, return value   */
   return tmp || val




sort_java_props: procedure expose jprops.
   M = 1                      /* define M for passes           */
   DO WHILE (9 * M + 4) < jprops.0
      M = M * 3 + 1
   END

   DO WHILE M > 0             /* sort stem                     */
      K = jprops.0 - M
      DO J = 1 TO K
         Q = J
         DO WHILE Q > 0
            L = Q + M
            IF jprops.Q <<= jprops.L THEN LEAVE
            tmp      = jprops.Q  /* switch elements            */
            jprops.Q = jprops.L
            jprops.L = tmp
            Q = Q - M
         END
      END
      M = M % 3
   END

   RETURN


