#!/usr/bin/rexx
/*
   name:    uno_create_Interface_List.rex
   purpose: create an ooRexx program that defines and returns a list of OOo XInterfaces
   author:  Rony G. Flatscher
   date:    2005-04-21
   changed: 2005-06-05, ---rgf, made sure that output file name is uppercased (for Unix to find it as well)
            2005-07-03, ---rgf, restructured code, so created code does not need editing anymore;
            uses jar.exe instead of unzip.exe; gives info from which jar-file the interface class comes from
            2005-07-31, --rgf, now uses all jar-archives in "OOoBase/program/classes"
            2005-12-28, ---rgf, renamed for the successor package "UNO", added Apache 2.0 license
            2008-03-28, ---rgf, actual year gets added dynamically to the copyright statement
            2008-07-08, ---rgf, now executes from the installation directory using the CLASSPATH
                                settings to find the OOo-jars containing interface classes; will
                                make a backup copy, before re-creating UNO_XINTERFACES.REX
            2008-07-12, ---rgf, changed sequence of OOo-jars to match what "unoinfo" of OOo 3.x shows,
                                now shows full path to jars, fixed a bug to show the year of running this program

   version: 1.5
   needs:   "jar.exe"
   remarks:  - needs a file containing the directory entries of the OOo jar-archives
             - change to the OOo/StarOffice homedirectory and from there into "program/classes" and
               run this program; will create a file "UNO_XINTERFACES.REX" which gets included
               by "UNO.CLS"

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2005-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/


   -- rgf, 2005-12-28, 2005-07-03; as per the docs; "sandbox.jar" needed for OOo < 2.0
-- jars="ridl.jar unoil.jar jurt.jar juh.jar sandbox.jar"
jars="juh.jar ridl.jar jurt.jar unoil.jar"
aJars=jars~makeArray(" ")  -- create an array out of the jar names
aStats=.array~new          -- array to contain the stats-entries

tab="09"x

xint.=0
xi=0 -- total of classes
xk=0 -- total of interface classes
rAdj=65     -- width to right-adjust path
do jar2 over aJars

  jar=findJarOnClassPath(jar2)   -- find jar-file
  if jar="" then
  do
     say "["jar2"]: file not found! "
     iterate
  end

  if pos(" ",jar)>0 then         -- if path contains blank, enquote with "
     jar='"'jar'"'
  address cmd "jar -tf"  jar " | rxqueue"   -- just lists the fully qualified path (from Java 1.1 thru 1.5)
   i=0
   k=0
   do while queued()>0           -- iterate over jar-output
      parse pull l
      i=i+1
      xi=xi+1

      lPos=l~lastPos("/")        -- find last slash
      if lPos>0, l~subChar(lPos+1)="X" then   -- last slash immediately followed by "X", then assume an interface class

      do
         xk=xk+1
         k=k+1
         rest=l

         xint.xk=changestr("/", rest, ".")~strip || tab || jar2 -- save jar-file
         xint.0=xk
      end
   end

   if k>0 then perc=100*k/i
          else perc=0.00
   perc="("format(perc, 3, 1)"%)"

   tmpStr=(jar":")~right(rAdj) i~right(5) "entries," k~right(5) perc " being XInterface class(es)"
   .error~say(tmpStr)         -- display stats
   aStats~append(tmpStr)      -- save string
end

if xk>0 then perc=100*xk/xi
        else perc=0.00
perc="("format(perc, 3, 1)"%)"

tmpStr=copies("-",rAdj+58) -- place a line
.error~say(tmpStr)
aStats~append(tmpStr)

tmpStr="totals:"~right(rAdj) xi~right(5) "entries," xk~right(5) perc " being XInterface class(es)"
.error~say(tmpStr)         -- display stats
aStats~append(tmpStr)      -- save string

call SysStemSort "xint."

fo="uno_xinterfaces.rex"~translate  -- use uppercase, this way it can be found on Unix as well

if stream(fo, "c", "QUERY EXISTS")<>"" Then  -- file exists, make a backup copy
do
   if pos("\",foTmp)>0 then   -- Windows
      cmd="copy"
   else                       -- Unix
      cmd="cp -f"

   cmd fo fo||"_bkp-"date("S")'T'time()~changeStr(":","")   -- copy
end

so=.stream~new(fo)~~open("Replace") -- open stream, delete file

d=.directory~new

max=0
maxCN=0

so~say("/* "                                                                                               )
so~say("   name:    " fo                                                                                    )
so~say("   purpose:  define the list of OOo interface classes"                                             )
so~say("   author:   Rony G. Flatscher "                                                                              )
so~say("   created: " date("s") time()                                                                      )
so~say('   usage:    just require file, then call the routine "OOo.getInterfaceList" to retrieve the list' )
so~say('')
so~say('   jars analyzed to create this file:')
do line over aStats
      so~say('            ' line)
end


so~say('')
so~say('  license:                                                                      ')
so~say('                                                                                ')
so~say('   ------------------------ Apache Version 2.0 license -------------------------')
so~say('      Copyright (C) 2006-' || date("S")~left(4) 'Rony G. Flatscher                                 ')
so~say('                                                                                ')
so~say('      Licensed under the Apache License, Version 2.0 (the "License");           ')
so~say('      you may not use this file except in compliance with the License.          ')
so~say('      You may obtain a copy of the License at                                   ')
so~say('                                                                                ')
so~say('          http://www.apache.org/licenses/LICENSE-2.0                            ')
so~say('                                                                                ')
so~say('      Unless required by applicable law or agreed to in writing, software       ')
so~say('      distributed under the License is distributed on an "AS IS" BASIS,         ')
so~say('      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  ')
so~say('      See the License for the specific language governing permissions and       ')
so~say('      limitations under the License.                                            ')
so~say('   -----------------------------------------------------------------------------')
so~say('')
so~say("*/"                                                                                                )
so~say
so~say("::ROUTINE UNO.getInterfaceList PUBLIC"                                                             )
so~say
so~say("   l=.list~of( -"                                                                                  )
do i=1 to xint.0
   parse var xint.i rest (tab) jar
   -- rest=xint.i

   if right(rest, 6)=".class" then rest=left(rest, length(rest)-6)

   lword=substr(rest, lastpos(".", rest)+1)

   d~rest=rest
   if d~hasEntry(lword) then
   do
      so~say( "/* ---> ["rest"]: class name ["lword"] in use already! ("d~entry(lword)") */ - ")
   end
   else
   do
      d~setentry(lword, rest)
   end

   max=max(max, length(rest))
   maxCN=max(maxCN, length(lword))
   so~say(pp(rest, jar, i, xint.0) )
end

so~say("   )")
so~say
so~say("-- maximum fully qualified class-name length:" max", maximum length of class name:" maxCN  )
so~say('-- say l~items "items in list l" /* should be:' xk 'items */' )
so~say
so~say('   return l'                                           )

  /* this is a pretty print */
::routine pp
  parse arg line, jar, i, last
  return "0909"x || ('"'line'"')~left(74) iif(i=last, " ", ",") ",   -- #" i~right(last~length) jar


::routine iif
  if arg(1)=.true then return arg(2)
                  else return arg(3)


   /* return path to jar-file that got passed in */
::routine findJarOnClassPath
  parse upper arg jarName

  cp=value("CLASSPATH", ,"ENVIRONMENT")   -- get classpath value
  if pos("\",cp)>0 then    -- on Windows, resp. FAT-derived FS ?
     path.sep=";"
  else                     -- Unix
     path.sep=":"

  arr=cp~makeArray(path.sep)  -- create an array
  do i over arr
     if pos(jarName, i~upper)>0 then   -- found, return it !
        return i
  end
  return ""                -- nothing found, return empty string
