#!/usr/bin/rexx
/* ---rgf, 2003-03-10, 2003-03-05, 2003-04-16, 2003-04-22 , 2003-06-01, 2005-12-28, 2006-01-05,
           2006-12-08
   tests the BSF4Rexx installation, queries all version information;
   can be invoked directly or via Java, e.g. "rexxj infoBSF.rex"

   license:

   ------------------------ Apache Version 2.0 license -------------------------
      Copyright 2006-2008 Rony G. Flatscher

      Licensed under the Apache License, Version 2.0 (the "License");
      you may not use this file except in compliance with the License.
      You may obtain a copy of the License at

          http://www.apache.org/licenses/LICENSE-2.0

      Unless required by applicable law or agreed to in writing, software
      distributed under the License is distributed on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      See the License for the specific language governing permissions and
      limitations under the License.
   -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") = 1 then   /* BSF() support not loaded yet ? */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs
   call BsfLoadJava
end

parse version version
say 'Rexx interpreter: ' pp(version)
say 'BSFManager        ' pp(bsf('invoke', bsf('getBSFManager'), 'getVersion'))
say 'BSF4Rexx (DLL/so):' pp(bsfVersion())
say 'Java Rexx engine: ' pp(bsf("version"))
say

   /* show the Java version in use for this invocation */
say 'Java version:     ' pp(bsf('invoke', 'System.class', 'getProperty', 'java.version' ))
say 'Java home dir:    ' pp(bsf('invoke', 'System.class', 'getProperty', 'java.home' ))
say
say 'Java library path:' pp(bsf('invoke', 'System.class', 'getProperty', 'java.library.path' ))
say
say 'Java class path:  ' pp(bsf('invoke', 'System.class', 'getProperty', 'java.class.path' ))
say

text="directly by Rexx which loaded Java"
if BsfInvokedBy()=1 then text="via Java"
say "This Rexx script was invoked:" pp(text)

say
call BsfQueryRegisteredFunctions "s."
say "The following BSF-functions are registered with Rexx:"
do i=1 to s.0
   say "  " pp(s.i)
end
exit

pp: procedure
    return "[" || arg(1) || "]"
