#!/usr/bin/rexx
/* ooRexx program to test access to the class 'datergf.DateTimeRGF', which is contained
   in the "bsf-rexx-engine.jar" archive; the documentation of the bsf4rexx
   Date/Time classes can be found in the archive "docs_bsf4rexx.zip"

   last change: $Revision: 286 $ $Author: rony $ $Date: 2008-09-13 21:14:51 +0200 (Sat, 13 Sep 2008) $

   changes:
         2008-06-23 rgf, changed code to reflect with the new return string format in
                         the BSF()-function calls (are now prepended with "<O>"
                         (BSFRegistry object) or "<S>" (plain string)
         2008-07-19, rgf, added hash-bang line at the top
         2008-09-09, rgf, changed "registerBeanStrict" to its synonym "newStrict" which
                          better describes the semantics of this subfunction

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."


.bsf~bsf.import("org.oorexx.datergf.DateTimeRGF",   "DateTimeRGF")   /* bsf.import the Java class*/
.bsf~bsf.import("org.oorexx.datergf.DateFormatRGF", "DateFormatRGF") /* bsf.import the Java class*/

dt1 = .DateTimeRGF~new                  /* create and get a DateTimeRGF object  */
say dt1~toString                        /* show its value                       */

dt1~update                              /* set to now                           */
say dt1~toString                        /* show the values                      */
say

i=3
say "now sleeping for" i "seconds ..."
call bsf 'sleep', i                     /* sleep i seconds using bsf4rexx       */
dt1~update                              /* set to now                           */
say dt1~toString                        /* show the values                      */

say
date1 = dt1~bsf.getFieldValue("date")   /* get DateRGF field                    */
say "date-portion:" date1~toString

                                        /* determine ISO-week, using a public static
                                           field of the interface "DTC"         */
week=date1~get(.bsf~bsf.getStaticValue("org.oorexx.datergf.DTC", "WEEK") )
say "today falls into ISO-week #" week
say

time1 = dt1~bsf.getFieldValue("time")   /* get TimeRGF field                    */
say "time-portion:" time1~toString
say

easter = date1~easter(date1)       /* get Easter sunday for this year      */
week=easter~get(.bsf~bsf.getStaticValue("org.oorexx.datergf.DTC", "WEEK") )
say "This year Easter sunday is:" easter~toString "which is ISO-week #" week
say


bStrict=random(0, 1)    /* determine which version should be used to create the Java object */
tmp=""
if bStrict then
do
   dLastFebruaryOf2008=bsf.wrap(bsf('newStrict', , "org.oorexx.datergf.DateTimeRGF","int", 2008, "int", "3", "int", '0', "int", 1, "int", 2, "int", 3))
   tmp=" with strict data typing!"
end
else
do
   dLastFebruaryOf2008=.dateTimeRgf~new(2008, 3, 0, 9, 8, 7)
end

say "Last February in 2008 is:" bsf.wrap(bsf('invoke', dLastFebruaryOf2008, "toString"))
say "     (hint: told to produce 0th March"tmp")"
say
say "---"
say

say "This demos the Java class 'DateFormatRGF':"
say
say "   the format string being used is:"
say

formatString="'Today is:' [EEEE], d. [MMM] yyyy, 'day #:' D (g 'to go'), hh:mm:ss.SSS [a]"
say formatString
say

df = .dateFormatRGF~new         /* get an instance of the dateformatter */

say df~format(formatString, dt1)
say "   ---"
say "   (now localizing the names of the months and days as well as the 'am/pm')"
df~localize
say df~format(formatString, dt1)
say "   the default formatting now produces:" '[' || dt1~toString || ']'
say "---"
say

locales.1="ITALIAN"
locales.2="FRENCH"
locales.3="UK"
locales.4="US"
locales.5="JAPANESE"
locales.0=5     /* indicate # of elements in stem ("hash")      */

do i=1 to locales.0
   say "trying to get the" locales.i "Locale from Java ("i "of" locales.0") ..."
   df~localize(.bsf~bsf.getStaticValue("java.util.Locale", locales.i))
   say df~format(formatString, dt1)
   say "   the default formatting now produces:" '[' || dt1~toString || ']'
   say "---"
end


say "More on the Java package 'datergf' can be found here or in 'org/orexx/datergf':"
say
say "or check the Internet starting with:"
say
say "   http://www.RexxLA.org"
say "   http://www.ooRexx.org"

::requires BSF.CLS            -- get the direct Object Rexx BSF support

