#!/usr/bin/rexx
/*
   name:      DateRgfSample.rex
   author:    Rony G. Flatscher
   date:      2006-02-15
   purpose:   show usage of the BSF.CLS-routine "bsf.wrapStaticFields" for accessing Java constants;
               this example translates the Java example code for
               "<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/docs/docs.bsf4rexx/org/oorexx/datergf/DateRGF.html>"
               to ooRexx; the Java code as per 2006-02-15 is depicted below, followed by the appropriate ooRexx code
   needs:     ooRexx, BSF4Rexx
   changes:
         2008-07-19, rgf, added hash-bang line at the top

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $


*/


/*
      DateRGF firstDate=new DateRGF(   1, 1, 1), // yields: '0001-01-01'
              lastDate =new DateRGF(9999,12,31); // yields: '9999-12-31'

      int     days=lastDate.subtract(firstDate); // yields: 3652060

      DateRGF tmpDate=(DateRGF)firstDate.clone();// yields: '0001-01-01'
      tmpDate.add(days);                         // yields: '9999-12-31'

                     // get Labor Monday in 2001
      tmpDate=new DateRGF(2001,8,31);            // yields: '2001-08-31', a Friday
      tmpDate.set(WEEKDAY, 1);                   // yields: '2001-09-03'

                     // get Labor Monday in 2001 in one line
      tmpDate=(new DateRGF(2001,8,31)).set(WEEKDAY,1); // yields: '2001-08-31', a Friday

      DateRGF d=valueOf(ENCODED_AS_INTEGER, 20190521);       // yields: '2019-05-21'

      d.set(WB, 0);              // yields: '2019-05-19', if weekStart=7 (Sunday)
      int iso_day=d.get(DOW);    // yields: 7 (ISO-number for Sunday)

      d.set(WB, 3);              // yields: '2019-05-22', if weekStart=7 (Sunday)
      d.set(WE, 0);              // yields: '2019-05-25', if weekStart=7 (Sunday)

      DateRGF easter=DateRGF.easter(d);          // yields: '2019-04-21'

      int palm_days=d.get(EPOCH_PALM);           // yields: 35430
      int java_days=d.get(EPOCH_JAVA);           // yields: 18041


           // if run on "2010-09-22 17:49:01" under Waba, then
      d.update();                // yields: '2010-09-22'

      String day_name  =getString(DN, d.get(DOW));           // yields: 'Saturday'
      String month_name=getString(MN, d.get(MONTH_FIELD));   // yields: 'May'
*/

.bsf~bsf.import("org.oorexx.datergf.DateRGF", "dateRgf") -- import the Java class, make it available as ".DATERGF"

   -- make all static fields of interface "DTC" available as an ooRexx directory object
dtc=bsf.wrapStaticFields("org.oorexx.datergf.DTC")


firstDate=.DateRGF~new(   1, 1, 1)  -- yields: '0001-01-01'
lastDate =.DateRGF~new(9999,12,31)  -- yields: '9999-12-31'

days=lastDate~subtract(firstDate)   -- yields: 3652060
say "firstDate="pp(firstDate~toString) "lastDate="pp(lastDate~toString) "days="pp(days)

tmpDate=firstDate~clone             -- yields: '0001-01-01'
tmpDate~add(days)                   -- yields: '9999-12-31'
say "tmpDate="pp(tmpDate~toString)

                     -- get Labor Monday in 2001
tmpDate=.DateRGF~new(2001,8,31)     -- yields: '2001-08-31', a Friday
tmpDate~set(dtc~WEEKDAY, 1)         -- yields: '2001-09-03'
say "Labor Monday in 2001:" pp(tmpDate~toString)

d=.datergf~valueOf(dtc~ENCODED_AS_INTEGER, 20190521)  -- yields: '2019-05-21'
say "d="pp(d~toString) "[.datergf~valueOf(dtc~ENCODED_AS_INTEGER)]"

d~set(dtc~WB, 0)                    -- yields: '2019-05-19', if weekStart=7 (Sunday)

iso_day=d~get(dtc~DOW)              -- yields: 7 (ISO-number for Sunday)
say "d="pp(d~toString) "[d~set(dtc~WB, 0)]; iso_day="pp(iso_day)

d~set(dtc~WB, 3)                    -- yields: '2019-05-22', if weekStart=7 (Sunday)
d~set(dtc~WE, 0)                    -- yields: '2019-05-25', if weekStart=7 (Sunday)
say "d="pp(d~toString) "[d~set(dtc~WE, 0) / d~set(dtc~WE, 0)]"

easter=.DateRGF~easter(d)           -- yields: '2019-04-21'
say "easter="pp(easter~toString)

palm_days=d~get(dtc~EPOCH_PALM)     -- yields: 35430
say "palm_days="pp(palm_days)
java_days=d~get(dtc~EPOCH_JAVA)     -- yields: 18041
say "java_days="pp(java_days)


     -- if run on "2010-09-22 17:49:01" under Waba, then
say "--- now updating DateRGF object to today's date:"
d~update                  -- yields: '2010-09-22'
say "d="pp(d~toString) "(= today !)"

day_name  =.datergf~getString(dtc~DN, d~get(dtc~DOW))            -- yields: 'Saturday'
month_name=.datergf~getString(dtc~MN, d~get(dtc~MONTH_FIELD))    -- yields: 'May'
say "day_name="pp(day_name) "month_name="pp(month_name)
say "this year's Easter sunday="pp(.DateRGF~easter(d)~toString)

laborday=.datergf~new(d~get(dtc~year_field), 8, 31)~set(dtc~WEEKDAY, 1) -- get next Monday
say "this year's Labor day="pp(laborday~toString)


::requires BSF.CLS      -- get Java support

