#!/usr/bin/rexx
/*
   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

   -- use the "BSF" proxy class object, emplyoing its class method "bsf.loadClass(...)"
system=.bsf ~bsf.loadClass("java.lang.System")

properties=system~getProperties  -- get the System properties

   -- create a TreeSet (an ordered set)
treeSet=.bsf~new("java.util.TreeSet")
      -- add properties names to tree set
enum=properties~propertyNames    -- get an enumeration of the property names
do while enum~hasMoreElements    -- loop over enumeration of property names
   treeSet~add(enum~nextElement) -- add next name
end

   -- iterate over names in treeSet order, show property name and its value
iter=treeSet~iterator            -- get an Iterator (order by treeSet)
do while iter~hasNext            -- iterate over names
   key=iter~next                 -- get next element
   say "key:" left("["key"]", 30) "value: ["properties~getProperty(key)"]"
end


::requires BSF.CLS      -- get the BSF4Rexx support for ooRexx
