#!/usr/bin/rexx
/*
   Name:    "Greetings.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in Greetings.rex"
                or
            "java org.apache.bsf.Main            -in Greetings.rex"
                or
            "rexxj Greetings.rex" (Windows)
                or
            "rexxj.sh Greetings.rex" (Unix)
                or
            "rexx Greetings.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

             This version stresses Object Rexx and the wrapper class "BSF.CLS" which
             makes Java look like if it was Object Rexx ...
             ;)

   Needs:    ooRexx, BSF4Rexx

   Date:    2001-04-18, 2003-01-23, 2003-05-10
            2003-09-05 creating java.awt.Color with giving strict types for arguments
            2005-06-05, adjusted for name changes of BSF class methods
            2005-12-28, added Apache license
            2008-06-01, updated text
            2008-08-23, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                                remove the first three chars from its result string)

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)

   Changes:
         2008-07-19, rgf, added hash-bang line at the top

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."


        /* create Object Rexx prox-classes for the following "java"-classes:    */
.BSF~bsf.import('java.awt.Button'    , 'awtButton'      )
.BSF~bsf.import('java.awt.Choice'    , 'awtChoice'      )
.BSF~bsf.import('java.awt.Color'     , 'awtColor'       )
.BSF~bsf.import('java.awt.Frame'     , 'awtFrame'       )
.BSF~bsf.import('java.awt.GridLayout', 'awtGridLayout'  )
.BSF~bsf.import('java.awt.Label'     , 'awtLabel'       )
.BSF~bsf.import('java.awt.TextField' , 'awtTextField'   )

        /* create 3 labels                                      */
Label1 = .awtLabel~new('Gender: ')
Label2 = .awtLabel~new('First Name: ')
Label3 = .awtLabel~new('Surname: ')

        /* create a drop down list with 2 entries               */
DropDown = .awtChoice~new
DropDown~~addItem('male')~~addItem('female')

        /* create 2 textfields                                  */
Surname = .awtTextField~new
Name    = .awtTextField~new

        /* create myDir for use with the Greetings routine;
           this allows us to access the registered objects      */
myDir=.directory~new
myDir~DropDown = DropDown;
myDir~Surname  = Surname;
myDir~Name     = Name;

        /* create 2 buttons and add addEventListeners to them   */
OK     = .awtButton~new('OK')
Cancel = .awtButton~new('Cancel')

        /* set the window layout                                */
-- Background = .awtColor~new(150, 150, 250)
Background = .awtColor~newStrict("int", 150, "int", 150, "int", 250)
GLayout    = .awtGridLayout~new(4, 2)
Window     = .awtFrame~new('OO-Greetings!')

        /* add all the elements to the window                   */
Window~setLayout(GLayout)
Window~~add(Label1)~~add(DropDown)
Window~~add(Label2)~~add(Name)
Window~~add(Label3)~~add(Surname)
Window~~add(OK)    ~~add(Cancel)
Window~setSize(200, 200)
Window~setBackground(Background)
Window~~pack~~show~~toFront

        /* no access needed anymore, free the references to
           the objects (just to demonstrate this feature)       */
drop label1
drop label2
drop label3

        /* now let Java notify us of the following events, sending
           us the indicated string                              */
OK    ~bsf.addEventListener('action', '',               'call Greetings myDir')
Cancel~bsf.addEventListener('action', '',               '.BSF~bsf.exit')      -- any action!
        /* wait 5 seconds before terminating the JVM, just for the fun of it    */
Window~bsf.addEventListener('window', 'windowClosing',  'ok~bsf.exit(-1, 5000)')

        /* run the addEventListener loop                        */
do forever
   a = bsf.pollEventText()      /* wait for an eventText to be sent     */
   say "received the following eventText: ["a"]"
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will terminate                           */
end

exit


::REQUIRES BSF.CLS            /* requires the BSF-class       */

        --open up a new window and greet the user
::ROUTINE Greetings
    use arg mydir       -- stores the objects to get to the gender and names

    Window2 = .awtFrame~new     /* create another window        */

    Greet   = .awtLabel~new     /* create a label               */
    Bye     = .awtButton~new('Bye!')  /* create a button      */

                /* add label and button to the window           */
    Window2~~add('North', Greet)~~add('South', Bye)
    Window2~~pack~~show~~toFront

                /* now prepare to put something into that window        */
    Gender  = myDir~DropDown~getSelectedItem    /* get chosen Item      */
    N1      = myDir~Name~getText                /* get entered text     */
    N2      = myDir~Surname~getText             /* get entered text     */

    if Gender = "male" then Greet~setText('Hello Mr.'  N1 N2)
                       else Greet~setText('Hello Mrs.' N1 N2)

                /* now let Java notify us of the following events, sending
                   us the indicated string                              */
    Window2~bsf.addEventListener('window', 'windowClosing', '.BSF~bsf.exit')
    Bye    ~bsf.addEventListener('action', '',              '.BSF~bsf.exit')


