#!/usr/bin/rexx
/*
   Name:    "HelloWorld.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in HelloWorld.rex"
                or
            "java org.apache.bsf.Main            -in HelloWorld.rex"
                or
             "rexxj HelloWorld.rex" (Windows)
                or
             "rexxj.sh HelloWorld.rex" (Unix)
                or
             "rexx HelloWorld.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

             This version stresses Object Rexx and the wrapper class "BSF.CLS" which
             makes Java look like if it was Object Rexx ...
             ;)

   Needs:    ooRexx, BSF4Rexx

   Date:    2001-04-18, 2003-01-23, 2003-05-10, 2005-06-05
            2005-12-28, added Apache license
            2008-06-01, updated text

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   changed:
         2008-08-23, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                             remove the first three chars from its result string)
         2008-07-19, rgf, added hash-bang line at the top

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

        /* create a Java awt window and a Java awt button       */
tmpWin = .awtFrame~new('Hello World!')

.bsf~bsf.import("java.awt.Button", "awtButton")     /* another way to define a Java class   */
tmpBut = .awtButton~new('Drck mich!')

        /* prepare window and show it, using cascading messages (two twiddles '~')   */
tmpWin ~~add(tmpBut) ~~pack ~~show ~~toFront

        /* define which eventText has to be sent on which event         */
tmpWin~bsf.addEventListener('window', 'windowClosing', 'call bsf "exit"')
tmpBut~bsf.addEventListener('action', ''             , 'call BSF exit')

        /* run the event loop, otherwise this instance of Rexx gets shut down   */
        /* dispatch the strings received as a result of the registered events   */
do forever
   a = bsf.pollEventText()    /* wait for an eventText to be sent     */
   interpret a                /* execute as a Rexx program            */
   say "(in Rexx), polled: ["a"]"
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown */
end
say "Now exiting Rexx."


::REQUIRES BSF.CLS    -- requires the BSF-class

        /* one way, how to define a Java class in Object Rexx   */
::CLASS "awtFrame" SUBCLASS bsf
::METHOD init
  self~init:super('java.awt.Frame', ARG(1, 'A'))

