/* elp_Frame.cls */

::requires bsf.cls
::routine elpFrame public
use arg name, text, height, width

    name = name .bsf4Rexx~version

-- Create a scrollable frame to display our text in
    f = .bsf~new('javax.swing.JFrame',name)
    f~bsf.addEventListener('window', 'windowClosing', '.bsf~bsf.exit')

    textArea=.bsf~new('javax.swing.JTextArea', height, width)
    textarea~setEditable(.false)
    textarea~setLineWrap(.false)

-- set TextArea to Courier Font
-- create font
    font = .bsf~new("java.awt.Font", "Courier", bsf.getConstant("java.awt.Font", "PLAIN"), 12) -- ; // rgf, 2006-01-17
    textArea~setFont(font)

-- Add our text string to the JTextArea
    textArea~setText(text)
    sp = .bsf~new('javax.swing.JScrollPane', textarea)
    f~getContentPane~add(sp, 'West')

    p = .bsf~new('javax.swing.JPanel')
    .bsf~bsf.import('javax.swing.JButton', 'javaButton')

    exitButton=.javaButton~new('Exit')
    exitButton~bsf.addEventListener('action', '', '.bsf~bsf.exit')
    exitButton~setMnemonic('x')
    p~add(exitButton)

    f~getContentPane~add(p, 'South')

    f~pack

    sw = f~getToolkit~getScreenSize~getWidth
    sh = f~getToolkit~getScreenSize~getHeight
    fw = f~getWidth
    fh = f~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    f~setLocation(fx,fy)
    f~~show~~tofront

    do forever
        txt = bsf.pollEventText()
        interpret txt
        if result = 'SHUTDOWN, REXX !' then leave
    end





