/* fileopendialogEE.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x
-- Create a file chooser by importing the Java class
    fchooser = .bsf~new('javax.swing.JFileChooser')
-- Create a frame to place the file chooser in by importing the Java class
    frame = .bsf~new('javax.swing.JFrame','Frame')
-- Set the current directory by importing the java.io.File class (the '.' indicates the current folder)
    fchooser~setCurrentDirectory( .bsf~new("java.io.File", ".") )
-- Give our file chooser a dialog
    fchooser~setDialogTitle('Java Swing File OPEN Dialog')
-- general on the patterns used (cf. <java.util.regex.Pattern>)
-- '^' symbol for begin of line
-- '$' symbol for end of line
-- '.' (dot) any character
-- '?' previous character (expression) can occur 0 or at most one time
-- '*' previous character (expression) can occur 0 or multiple times
-- '+' previous character (expression) can occur 1 or multiple times
-- '(' and ')' allows to group character sequences/expressions
-- import Java class into ooRexx - the hidden Easter Egg
    call bsf.import 'org.oorexx.misc.RgfFilter', 'RgfFilter'
-- must end with 'rex' or 'txt' in lower, mixed or upper case;
-- '$' is the symbol in regular expressions for end-of-line
    filter=.rgfFilter~new('*.rex;*.txt')          -- create a new filter
    filter~setPattern(".*\.([rR][eE][xX]|[tT][xX][tT])$")
    fchooser~setFileFilter(filter)                -- set the filter to fileDialog
-- Show the dialog and display back to the user their selection
    myfile = fchooser~showOpenDialog(frame)
    text = 'Result Of The File OPEN Dialog With EE'
    if myfile = 0 then
        do
            text = text||lf'Fully Qualified File =' fchooser~getSelectedFile~getPath
            text = text||lf'Just File Name       =' fchooser~getSelectedFile~getName
        end
    else
        text = text||lf'You Clicked Cancel'
    call elpFrame 'Example of the Java FOD Class With Filters', text, 3, 74

::requires 'elpFrame.rex'

