/* swing_multiinput4.rex */
/*
This demonstration was written in ooRexx by Lee Peedin
using BSF4Rexx, created and distributed by Dr. Rony Flatscher.
The latest release of BSF4Rexx can be found at:
<http://wi.wu-wien.ac.at/rgf/rexx/bsf4rexx/current/>
The latest information on ooRexx can be found at:
<http://www.oorexx.org/>
Some demonstrations may require these additional Java classes
SWT         <http://www.eclipse.org/swt/>
FreeTTS     <http://freetts.sourceforge.net/docs/index.php>

This demonstration has been tested using:
ooRexx              3.0.1
Java Version        1.5.0_06
Windows Version     Microsoft Windows XP [Version 5.1.2600]
Linux Version       Suse 10
*/
    parse source os how what
    call SysCls
    lf = '0a'x

    call bsf.import 'java.awt.GridBagLayout'        , 'GridBagLayout'
    call bsf.import 'java.awt.GridBagConstraints'   , 'GridBagConstraints'
    call bsf.import 'java.awt.GridLayout'           , 'GridLayout'
    call bsf.import 'java.awt.Insets'               , 'Insets'
    call bsf.import 'javax.swing.JButton'           , 'JButton'
    call bsf.import 'javax.swing.JFrame'            , 'JFrame'
    call bsf.import 'javax.swing.JLabel'            , 'JLabel'
    call bsf.import 'javax.swing.JPanel'            , 'JPanel'
    call bsf.import 'javax.swing.JRadioButton'      , 'JRadioButton'
    call bsf.import 'javax.swing.JTextField'        , 'JTextField'
    call bsf.import 'javax.swing.JTextArea'         , 'JTextArea'

--  Define a font
    courier_norm = .bsf~new('java.awt.Font','Courier',bsf.getConstant('java.awt.Font', 'PLAIN'),14)
-- Retrieve the value of several colors
    gray         = .bsf~bsf.getStaticValue('java.awt.Color','lightgray')
    blue         = .bsf~bsf.getStaticValue('java.awt.Color','blue')
    orange       = .bsf~bsf.getStaticValue('java.awt.Color','orange')

-- Create a Rexx queue to hold our "posted" data
    pique = .queue~new

-- Load gridbagconstraints
    gbc = bsf.wrapStaticFields('java.awt.GridBagConstraints')

-- Create a frame with a title
    frame = .JFrame~new('Swing MultiInput GUI')

-- Don't let the user click the X button
    frame~setDefaultCloseOperation(frame~DO_NOTHING_ON_CLOSE)
-- Don't let the user resize the frame
    frame~setResizable(.false)

-- Get the default pane of the frame
    pane = frame~getContentPane
-- Apply gridbaglayout manager to the pane
    pane~setLayout(.GridBagLayout~new)

-- Get the contraints
    c = .GridBagConstraints~new
-- Set the constraints
    c~insets = .Insets~new(5,5,5,5)
    c~fill = gbc~vertical
    c~anchor = gbc~line_start

-- Create a label with a value
    fname_label = .JLabel~new('First Name')
-- Set the x position for this label
    c~gridx = 0
-- Set the y position for this label
    c~gridY = 0
-- Add the label to the pane using the constraints (c)
    pane~add(fname_label,c)

-- Create an empty text field 30 characters wide
    fname_field = .JTextField~new('',30)
-- Add a focus listener
    fname_field~bsf.addEventListener("focus", "focusGained", "fname_field~selectAll")
-- Add a key listener
    fname_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
-- Set the x position of this field
    c~gridx = 1
-- Set the y position of this field
    c~gridY = 0
-- Add the field to the pane
    pane~add(fname_field,c)

-- Continue creating labels & textfields and adding them to the pane
    lname_label = .JLabel~new('Last Name')
    c~gridx = 0
    c~gridY = 1
    pane~add(lname_label,c)

    lname_field = .JTextField~new('',20)
    lname_field~bsf.addEventListener("focus", "focusGained", "lname_field~selectAll")
    lname_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    c~gridx = 1
    c~gridY = 1
    pane~add(lname_field,c)

    age_label = .JLabel~new('Age')
    c~gridx = 0
    c~gridY = 2
    pane~add(age_label,c)

    age_field = .JTextField~new('',2)
    age_field~bsf.addEventListener("focus", "focusGained", "age_field~selectAll")
    age_field~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    c~gridx = 1
    c~gridY = 2
    pane~add(age_field,c)

-- Create buttons with hot-keys & listeners
    OkButton = .JButton~new('OK')
    OkButton~setMnemonic('o')
    OkButton~bsf.addEventListener('action', '', 'call ShowIt vars')
    OkButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    c~gridx = 0
    c~gridY = 3
    pane~~add(OkButton,c)

    exitButton = .JButton~new('Exit')
    exitButton~setMnemonic('x')
    exitButton~bsf.addEventListener('action', '', '.bsf~bsf.exit')
    exitButton~bsf.addEventListenerReturningEventInfos('key','keyPressed','')
    c~gridx = 1
    c~gridY = 3
    pane~add(exitButton,c)

    rb1 = .JRadioButton~new('Change Entry')
    rb1~setMnemonic('c')
    rb1~bsf.addEventListener('action', '', 'call ChangeOne vars')
    rb1~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

    rb2 = .JRadioButton~new('Delete Entry')
    rb2~setMnemonic('d')
    rb2~bsf.addEventListener('action', '', 'call DeleteOne vars')
    rb2~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

    rb3 = .JRadioButton~new('Average Age')
    rb3~setMnemonic('a')
    rb3~bsf.addEventListener('action', '', 'call Average vars')
    rb3~bsf.addEventListenerReturningEventInfos('key','keyPressed','')

-- Create a gridlayout 4 rows by 1 column
    glo = .GridLayout~new(4,1)
-- Create a panel
    panel1 = .JPanel~new
-- Apply the layout to the panel
    panel1~setLayout(glo)
-- Add the radio buttons to the panel
    panel1~~add(rb1)~~add(rb2)~~add(rb3)
-- Add the panel to the frame
    c~gridx = 0
    c~gridY = 4
    pane~add(panel1,c)

-- Create a panel
    panel2 = .JPanel~new
-- Create a text area 7 rows by 60 columns
    textArea = .JTextArea~new(7,60)
-- Set the font of the textarea
    textArea~setFont(courier_norm)
-- Set the background color
    textArea~setBackGround(gray)
-- Set the foreground color
    textArea~setForeGround(blue)
-- Make the text area non-editable
    textArea~setEditable(.false)
-- Add the text area to the panel
    panel2~add(textArea)
-- Add the panel to the frame
    c~gridx = 1
    c~gridY = 4
    pane~add(panel2,c)

-- Pack & show the frame
    frame~pack
    sw = frame~getToolkit~getScreenSize~getWidth
    sh = frame~getToolkit~getScreenSize~getHeight
    fw = frame~getWidth
    fh = frame~getHeight
    fx = (sw-fw)~format(,0)
    fy = 0
    frame~setLocation(fx,fy)
    frame~~show~~tofront

-- Create a bsf.dialog modal to "frame" for our message dialogs
    frameDlg=.bsf.dialog~new(frame)

-- Create a directory to hold our variables for the sub-routines
    vars = .directory~new
    vars~fname_field = fname_field
    vars~lname_field = lname_field
    vars~age_field = age_field
    vars~rb1 = rb1
    vars~rb2 = rb2
    vars~rb3 = rb3
    vars~textArea = textArea
    vars~pique = pique
    vars~lf = lf
    vars~changed_one = 0
    vars~orange = orange
    vars~normalbg = fname_field~getBackGround
    vars~fd = frameDlg

-- Listen for events
    do forever
        do until .nil = rexxCode
            rexxCode = bsf.pollEventText(1)
            if .nil \= rexxCode then
                do
                    if ABBREV(rexxCode, '/*BSFBEAN/*') then
--if rexxCode~pos('BSFBEAN') = 3 then
                        do
                            eventInfo=bsf.getEventInfoObject(rexxCode)
                            eventObject=eventInfo[1][1]
                            select
                                when wasEscapeKeyPressed(eventObject) then call BSF 'exit'
                                when wasEnterKeyPressed(eventObject) then call ShowIt vars
                                otherwise nop
                            end
                        end
                    else
                        interpret rexxCode
                end
        end
    end

exit

::requires bsf.cls

::routine ShowIt
    use arg vars
    fname_field = vars~fname_field
    lname_field = vars~lname_field
    age_field = vars~age_field
    textArea = vars~textArea
    lf = vars~lf
    pique = vars~pique
    changed_one = vars~changed_one
    orange = vars~orange
    normalbg = vars~normalbg
    frameDlg = vars~fd

    fname = fname_field~getText~strip
    lname = lname_field~getText~strip
    age = age_field~getText~strip

    select
        when fname = '' then
            do
                frameDlg~messageBox('First Name Can Not Be Empty','Error In First Name','error')
                fname_field~setBackGround(orange)
                lname_field~setBackGround(normalbg)
                age_field~setBackGround(normalbg)
                fname_field~grabFocus
            end
        when lname = '' then
            do
                frameDlg~messageBox('Last Name Can Not Be Empty','Error In Last Name','error')
                lname_field~setBackGround(orange)
                fname_field~setBackGround(normalbg)
                age_field~setBackGround(normalbg)
                lname_field~grabFocus
            end
        when \age~datatype('w') then
            do
                frameDlg~messageBox('Age Must Be A Whole Number','Error In Age','error')
                age_field~setBackGround(orange)
                fname_field~setBackGround(normalbg)
                lname_field~setBackGround(normalbg)
                age_field~grabFocus
            end
        otherwise
            do
                stg = fname~left(30) lname~left(20) age~right(3)
                if changed_one > 0 then
                    do
                        pique[changed_one] = stg
                    end
                else
                    do
                        if pique~items = 5 then
                            pique~remove(5)
                        pique~push(stg)
                    end

                textArea~setText('')
                text = '#  ' 'First Name'~left(30) 'Last Name'~left(20) 'Age'~left(3) lf
                do i = 1 to pique~items
                    text = text||i~left(3) pique[i] lf
                end
                textArea~setText(text)

                fname_field~setText('')
                lname_field~setText('')
                age_field~setText('')
                fname_field~setBackGround(normalbg)
                lname_field~setBackGround(normalbg)
                age_field~setBackGround(normalbg)
                fname_field~grabFocus
                vars~changed_one = 0
            end
    end

::routine ChangeOne
    use arg vars
    fname_field = vars~fname_field
    lname_field = vars~lname_field
    age_field = vars~age_field
    pique = vars~pique
    rb1 = vars~rb1
    frameDlg = vars~fd
    text='Select The Line To Change'

    prev = .array~new

    do aa = 1 to pique~items
        if pique[aa] \= '' then
            do
                prev[prev~items+1] = aa~right(2) '-' pique[aa]
            end
    end
    rv = frameDlg~inputBox(text, 'Change Existing Entry', 'question', .nil, prev)
    if .nil \= rv then
        do
            w_one = rv~word(1)
            fname = pique[w_one]~left(30)~strip
            lname = pique[w_one]~substr(32,20)~strip
            age = pique[w_one]~right(3)~strip
            fname_field~setText(fname)
            lname_field~setText(lname)
            age_field~setText(age)

            changed_one = w_one
            vars~changed_one = changed_one
        end
    fname_field~grabFocus
    rb1~setSelected(.false)

::routine DeleteOne
    use arg vars
    fname_field = vars~fname_field
    lname_field = vars~lname_field
    age_field = vars~age_field
    pique = vars~pique
    rb2 = vars~rb2
    frameDlg = vars~fd
    textArea = vars~textArea
    lf = vars~lf

    text='Select The Line To Delete'

    prev = .array~new

    do aa = 1 to pique~items
        if pique[aa] \= '' then
            do
                prev[prev~items+1] = aa~right(2) '-' pique[aa]
            end
    end
    rv = frameDlg~inputBox(text, 'Delete Existing Entry', 'question', .nil, prev)
    if .nil \= rv then
        do
            w_one = rv~word(1)
            pique~remove(w_one)

            textArea~setText('')
            text = '#  ' 'First Name'~left(30) 'Last Name'~left(20) 'Age'~left(3) lf
            do i = 1 to pique~items
                text = text||i~left(3) pique[i] lf
            end
            textArea~setText(text)

            fname_field~setText('')
            lname_field~setText('')
            age_field~setText('')
        end

    fname_field~grabFocus
    rb2~setSelected(.false)

::routine Average
    use arg vars
    fname_field = vars~fname_field
    pique = vars~pique
    rb3 = vars~rb3
    frameDlg = vars~fd

    text='The Average Age Is'

    total = 0
    ctr = 0
    do aa = 1 to pique~items
        if pique[aa] \= '' then
            do
                ctr = ctr + 1
                total = total + pique[aa]~right(3)
            end
    end
    if ctr > 0 then
        do
            average = total / ctr
            rv = frameDlg~messageBox(text average, 'Average Existing Entries', 'information', .nil, average)
        end
    else
        do
            text = 'No Existing Entries To Average'
            rv = frameDlg~messageBox(text, 'Error', 'error', .nil)
        end
    fname_field~grabFocus
    rb3~setSelected(.false)

::routine wasEscapeKeyPressed
    use arg eventObject
    keyCode=eventObject~keyCode
    return keyCode = 27

::routine wasEnterKeyPressed
    use arg eventObject
    keyCode=eventObject~keyCode
    return keyCode = 10



