-- Example 04
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- use the TextCursor to count the paragrahs, sentences and words of an existing
-- swriter-file
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"
--                      copied "textdocument01.sxw" to "http://wi.wu-wien.ac.at/rgf/diplomarbeiten/BakkStuff/2005/"

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the sxw-file hidden from the internet */
-- url = "http://www.wu-wien.ac.at/usr/h02c/h0251406/e-commerce/vk6/textdocument01.sxw"

url="http://wi.wu-wien.ac.at/rgf/diplomarbeiten/BakkStuff/2005/textdocument01.sxw"

props = bsf.createArray(.UNO~propertyValue, 1)     -- create Java array
props[1]=uno.createProperty("Hidden", box("boolean", .true))
xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, props)

/* create a TextCursor */
xTextCursor = xWriterComponent~XTextDocument~getText~createTextCursor

/* create a Word-, Sentence- and ParagraphCursor */
xWordCursor      = xTextCursor~XWordCursor
xSentenceCursor  = xTextCursor~XSentenceCursor
xParagraphCursor = xTextCursor~XParagraphCursor

/* count paragraphs */
xTextCursor~gotoStart(.false)
paragraphs = 1                -- you start with the first paragraph
DO WHILE xParagraphCursor~gotoNextParagraph(.false) = .true
	paragraphs = paragraphs + 1
END

/* count sentences */
xTextCursor~gotoStart(.false)
sentences = 1                 -- you start with the first sentence
DO WHILE xSentenceCursor~gotoNextSentence(.false) = .true
	sentences = sentences + 1
END

/* count words */
xTextCursor~gotoStart(.false)
words = 1                     -- you start with the first word
DO WHILE xWordCursor~gotoNextWord(.false) = .true
	words = words + 1
END

/* show statistics */
SAY "paragraphs:" paragraphs
SAY "sentences:" sentences
SAY "words:" words

::requires UNO.CLS    -- get UNO support