-- Example 06
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- edit the text of a swirter-file

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxw - file */
url = "private:factory/swriter"
xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* create the TextObject */
xWriterDocument = xWriterComponent~XTextDocument
xText = xWriterDocument~getText

/* create a Text- and a WordCursor */
xTextCursor = xText~createTextCursor
xWordCursor = xTextCursor~XWordCursor

/* create the CursorProperty */
xTextCursorProps = xTextCursor~XPropertySet

/* write the sentence */
xText~setString("This is the text!")
say "sleeping..."
CALL syssleep 2

/* insert the word "old" */
say "inserting the word 'old' into the text..."
xTextCursor~gotoStart(.false)
xWordCursor~~gotoNextWord(.false)~~gotoNextWord(.false)~~gotoNextWord(.false)
xText~insertString(xWordCursor, "old ", .false)
xTextCursor~gotoEnd(.false)
say "sleeping..."
CALL syssleep 2

/* replace the word "old" */
xTextCursor~gotoStart(.false)
xWordCursor~~gotoNextWord(.false)~~gotoNextWord(.false)~~gotoNextWord(.false) ~~gotoNextWord(.true)
xText~insertString(xWordCursor, "new ", .true) -- .true = replace mode
xTextCursor~gotoEnd(.false)
say "sleeping..."
CALL syssleep 2

/* create a PageCursor */
xPageCursor = xWriterDocument~XModel~getCurrentController ~XTextViewCursorSupplier -
                             ~getViewCursor~XPropertySet~XPageCursor

/* insert the current PageNumber */
say "inseritng the page number..."
xText~insertString(xWordCursor, (" [on page " || xPageCursor~getPage || "]") , .false)

/* change the color of the characters */
xTextCursorProps~setPropertyValue("CharColor", box("int", "ff 00 00"x ~c2d))

/* insert a colored smilie */
say "sleeping..."
CALL syssleep 1;   xText~insertString(xWordCursor, " ;", .false)
say "sleeping..."
CALL syssleep 0.5; xText~insertString(xWordCursor, "-", .false)
say "sleeping..."
CALL syssleep 0.5; xText~insertString(xWordCursor, ")", .false)

/* set "modified" false -> UNO will not ask if you want to save the current document on close */
xWriterComponent~XModifiable~setModified(.false)

::requires UNO.CLS    -- get UNO support

