-- Example 07
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- insert a table in an empty swriter-file

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxw - file */
url = "private:factory/swriter"
xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* create the TextObject and the TextCursor */
xTextDocument = xWriterComponent~XTextDocument
xText = XTextDocument~getText
xTextCursor = xText~createTextCursor

/* create the MulitServiceFactory from the current document */
/* (otherwise the created objects cannot be inserted into the document) */
xDMsf = xTextDocument~XMultiServiceFactory

/* create the TextTable */
xTextTable = xDMsf~createInstance("com.sun.star.text.TextTable")~XTextTable
xTextTable~initialize(4, 4)

/* insert TextTable in the Text */
xText~insertTextContent(xTextCursor, xTextTable, .false)

/* insert text in the TextTable */
CALL setCellText "A1", "One",   xTextTable
CALL setCellText "B1", "Two",   xTextTable
CALL setCellText "C1", "Three", xTextTable
CALL setCellText "D1", "Four",  xTextTable

/* insert values in the TextTable */
xTextTable~getCellByName("A2")~setValue(2)
xTextTable~getCellByName("A3")~setValue(1)
xTextTable~getCellByName("B2")~setValue(5)
xTextTable~getCellByName("B3")~setValue(7)
xTextTable~getCellByName("C2")~setValue(3)
xTextTable~getCellByName("C3")~setValue(4)
xTextTable~getCellByName("D2")~setValue(8)
xTextTable~getCellByName("D3")~setValue(6)

/* insert formulars in the TextTable */
xTextTable~getCellByName("A4")~setFormula("sum <A2:A3>")
xTextTable~getCellByName("B4")~setFormula("sum <B2:B3>")
xTextTable~getCellByName("C4")~setFormula("sum <C2:C3>")
xTextTable~getCellByName("D4")~setFormula("sum <D2:D3>")

/* create the TextTableCursor */
xTextTableCursor = xTextTable~createCursorByCellName("A4")
xTextTableCursorProps = xTextTableCursor~XPropertySet
bgColor = box("int", "00 ff ff"x ~c2d)   -- determine color
xTextTableCursorProps~setPropertyValue("BackColor", bgColor)
xTextTableCursor~gotoCellByName("B4", .true)
xTextTableCursorProps~setPropertyValue("BackColor", bgColor)
xTextTableCursor~gotoCellByName("C4", .true)
xTextTableCursorProps~setPropertyValue("BackColor", bgColor)
xTextTableCursor~gotoCellByName("D4", .true)
xTextTableCursorProps~setPropertyValue("BackColor", bgColor)

::requires UNO.CLS    -- get UNO support

/* routine to set the text in a cell
   - cell: the cell you want to write in
   - text: the text you want to write in the cell
   - xTextTable: the table you want to use
*/
::routine setCellText

  	use arg cell, text, xTextTable

	xCellText = xTextTable~getCellByName(cell)~XText
	xCellCursor = xCellText~createTextCursor()
	cursorProps = xCellCursor~XPropertySet
	cursorProps~setPropertyValue("CharColor", box("int", "ff 00 00"x ~c2d))
	xCellText~setString(text)