-- Example 08
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- insert a textfield (with the current time) in an empty *.sxw - file

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxw - file */
url = "private:factory/swriter"
xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)
/* create the TextObject and the TextCursor */
xTextDocument = xWriterComponent~XTextDocument
xText = XTextDocument~getText()
xTextCursor = xText~createTextCursor()

/* create the MulitServiceFactory for the current document */
/* (otherwise the created objects cannot be inserted into the document) */
xDMsf = xTextDocument~XMultiServiceFactory

/* create the TextFields */
xTextFieldTime1 = xDMsf~createInstance("com.sun.star.text.TextField.DateTime") ~XTextField
-- set the properties for TextFieldTime1- so we can see the date
xTextFieldTime1~XPropertySet~setPropertyValue("IsDate", box("boolean", .true))

xTextFieldTime2 = xDMsf~createInstance("com.sun.star.text.TextField.DateTime") ~XTextField

/* insert the TextFieldTime1 */
xTextCursor~gotoStart(.false)
xText~insertTextContent(xTextCursor, xTextFieldTime1, .false)

/* insert a "paragraph_break" and the TextFieldTime2 */
xTextCursor~gotoEnd(.false)
xText~insertControlCharacter(xTextCursor, -
      bsf.getConstant("com.sun.star.text.ControlCharacter", "PARAGRAPH_BREAK"), .false)
xText~insertTextContent(xText~getEnd, xTextFieldTime2, .false)

/* set "modified" false -> UNO will not ask to save the current document
   on close */
xWriterComponent~XModifiable~setModified(.false)

::requires UNO.CLS    -- get UNO support
