-- Example 09
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- you have an inquiry - so make an order...
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxw - file */
url = makeUrl("inquiry.sxw")  -- get the document from the current folder
xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)
say "sleeping..."
CALL syssleep 3

/* create the TextObject */
xWriterDocument = xWriterComponent~XTextDocument
xText = xWriterDocument~getText

/* create TextCursors */
xTextCursor = xText~createTextCursor

/* create the ReplaceDescriptor */
xReplaceable = xWriterDocument~xReplaceable
xReplaceDescriptor = xReplaceable~createReplaceDescriptor()

/* search for "Inquiry" and replace it with "Order" in BOLD weight */
xReplaceDescriptor~~setSearchString("inquiry")~~setReplaceString("Order")

props = bsf.createArray(.UNO~propertyValue, 1)  -- create Java array
props[1]=uno.createProperty("CharWeight", box("float", bsf.getConstant("com.sun.star.awt.FontWeight", "BOLD")))

-- replace text gets formatted in BOLD font weight
xReplaceDescriptor~XPropertyReplace~setReplaceAttributes(props)

-- now do the replace
xReplaceable~replaceAll(xReplaceDescriptor)

/* insert a text from another textdocument */
xTextCursor~gotoEnd(.false)

insertURL = makeUrl("ordertext.sxw") -- get the document from the current folder
xTextCursor~XDocumentInsertable~xDocumentInsertable ~insertDocumentFromURL(insertURL, .UNO~noProps)

/* save the document under a new name */
xWriterComponent~XStorable~storeAsURL(makeUrl("order.sxw"), .UNO~noProps)

::requires UNO.CLS    -- get UNO support

-- A function for getting the file in the current folder

::routine makeUrl
  return  ConvertToURL(stream(arg(1), "c", "query exists"))