-- Example 10
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- Open an existing textfile and convert it to *.pdf
-- Possible files are *.sxw, *.doc, *.txt,....
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

-- Retrieve the Desktop object, we need its XComponentLoader interface to load a new document
oDesktop         = UNO.createDesktop(xContext) -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* create the FilePickerDialog */
url = getFileName(xMcf, xContext)      -- get file name from user
IF url =.nil THEN EXIT                 -- user did not pick a file
SAY "File:" pp(ConvertFromURL(url)) "..."

props = bsf.createArray(.UNO~propertyValue, 1)     -- create Java array
props[1]=uno.createProperty("Hidden", box("boolean", .true))

xWriterComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, props)
xStorable = xWriterComponent~XStorable -- get xStorable interface

/* convert it to *.pdf */
props = bsf.createArray(.UNO~propertyValue, 2)     -- create Java array
props[1]=uno.createProperty("FilterName",   "writer_pdf_Export")
props[2]=uno.createProperty("CompressMode", 2)

storeURL = substr(url, 1, lastpos(".", url)) || "pdf"   -- create output file name
xStorable~storeToUrl(storeURL, props)          -- store the file with props to URL

say "File:" pp(ConvertFromURL(storeURL)) "successfully created!"

::requires UNO.CLS    -- get UNO support

::routine getFileName -- FilePicker dialog to ask the user to pick a file to convert
   use arg xMcf, xContext ,oDesktop       -- retrieve multi service factory

   fd = xMcf~createInstanceWithContext("com.sun.star.ui.dialogs.FilePicker", xContext)
   xfp = fd~XFilePicker  -- get the interface for driving the FilePicker functionality

   urlPath = convertToUrl(directory())  -- convert current directory to URL
   xfp~setDisplayDirectory(urlPath)     -- determine directory to start out with
   ret = xfp~setTitle(date("S") time() || ": Please choose a writer file to convert to PDF!")

   xfm = xfp~XFilterManager     -- get the filter manager interface
   fileTypes = "*.sxw;*.doc;*.txt;*.text"
   xfm~appendFilter("Text files" pp(fileTypes), fileTypes) -- first filter is "current" one
   xfm~appendFilter("All files", "*")

   ret = xfp~execute            -- execute the dialog
   IF ret=1 THEN                -- 1...o.k., 0...cancel
      file = xfp~files[1]

   fd~XComponent~dispose        -- close dialog

   IF ret=1 THEN return file
   return .nil                  -- canceled by user
