-- Example 12
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a *.sxw - file and print a specified area 2 times
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface

/* get file from current directory, turn it into an UNO URL */
url = makeUrl("print.sxc")   -- get the document from the current folder
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* create a cell range, then get the CellRangeAddress */
myRange = xSheet~XCellRange~getCellRangeByName("B6:E13")
myAddr = myRange~XCellRangeAddressable~getRangeAddress

-- load the required class "com.sun.star.table.CellRangeAddress"
CALL UNO.loadClass "com.sun.star.table.CellRangeAddress"

oAddr = bsf.createArray(.UNO~CellRangeAddress, 1) -- create Java array
oAddr[1] = myAddr                                 -- assign CellRangeAddress
xSheet~XPrintAreas~setPrintAreas(oAddr)           -- set PrintAreas

/* set the printer */
xPrintable = xCalcComponent~XPrintable
props = bsf.createArray(.UNO~propertyValue, 1)    -- create Java array
/*
props[1] = .UNO~PropertyValue~new
props[1]~Name  = "Name"
props[1]~Value = "hp deskjet 5600 series" -- the name of your printer
*/
props[1]=uno.createProperty("Name", "hp deskjet 5600 series") -- the name of your printer
xPrintable~setPrinter(props)

props[1]~Name  = "CopyCount"
props[1]~Value = box("short", 2)          -- two copies
xPrintable~print(props)                   -- print it

::requires UNO.CLS    -- get UNO support

::routine makeUrl    -- operating system independent
  return  ConvertToURL(stream(arg(1), "c", "query exists"))