-- Example 13
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a blank *.sxc - file and test the formats

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxc - file */
url = "private:factory/scalc"
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* insert some text */
CALL UNO.setCell xSheet, 0, 0, "Matr.Nr.:"
CALL UNO.setCell xSheet, 1, 0, "0251406"

CALL UNO.setCell xSheet, 0, 1, "Datum:"
-- Remember: even if you have another version of UNO then the english one,
-- you still have to write the formulas in english
CALL UNO.setCell xSheet, 1, 1, "=TODAY()"

/* format the cells via xCell*/
xCell = xSheet~getCellByPosition(1, 1) -- cell "A2"
xPropertySet11 = xCell~XPropertySet~setPropertyValue("CellBackColor", box("int", "00 00 ff"x ~c2d))

xCell = xSheet~getCellByPosition(0, 1)  -- cell "B2"
xPropertySet01 = xCell~XPropertySet~setPropertyValue("CharColor",     box("int", "ff 00 00"x ~c2d))

/* format the cells voa xCellRange */
xPropSet = xSheet~XCellRange~getCellRangeByName("A1:B1")~XPropertySet
xPropSet~setPropertyValue("CharWeight", box("float", bsf.getConstant("com.sun.star.awt.FontWeight", "BOLD")))

::requires UNO.CLS -- get UNO support
