-- Example 14
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a blank *.sxc - file and test the autofill-function

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxw - file */
url = "private:factory/scalc"
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* insert some text */
CALL UNO.setCell xSheet, 0, 0, "1"                 -- cell "A1"
CALL UNO.setCell xSheet, 1, 0, "=(A1*3)"           -- cell "B1"
CALL UNO.setCell xSheet, 2, 0, "=($A$1*10*RAND())" -- cell "C1"
CALL UNO.setCell xSheet, 3, 0, "1"                 -- cell "D1"

/* and AutoFill it */
to_bottom = bsf.getConstant("com.sun.star.sheet.FillDirection", "TO_BOTTOM")
getCellSeries(xSheet, "A1:C10")~fillAuto(to_bottom, 1)
getCellSeries(xSheet, "D1:D10")~fillAuto(to_bottom, 2)

/* save the result - we need it for the next example */
storeURL = makeURL("testnumbers.sxc")  -- save the document in the current folder
xCalcComponent~XStorable~storeAsURL(storeURL, .UNO~noProps)

::requires UNO.CLS    -- get UNO support

::routine getCellSeries
  use arg xSheet, aRange
  return xSheet~XCellRange~getCellRangeByName(aRange)~XCellSeries

-- A function for getting the file in the current folder

::routine makeUrl
  return  ConvertToURL(directory() || "\" || arg(1))