-- Example 15
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open an existing *.sxc - file, insert a header and sort the first column ascendingly
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface

/* open the "testnumbers.sxc" from current folder/directory */
url = ConvertToURL(directory() || "\testnumbers.sxc")
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* create the CellRange */
xRange = xSheet~XCellRange~getCellRangeByName("A1:A10")

/* define the fields to sort */
CALL UNO.loadClass "com.sun.star.table.TableSortField" -- load UNO-class

tableSortField = bsf.createArray(.UNO~TableSortField, 1)    -- create Java array
tableSortField[1] = .UNO~TableSortField~new
tableSortField[1]~Field           = 1
tableSortField[1]~IsAscending     = .true
tableSortField[1]~IsCaseSensitive = .false

/* define the sort descriptor */
props = bsf.createArray(.UNO~propertyValue, 2)              -- create Java array
props[1]=uno.createProperty("ContainsHeader", box("boolean", .true))
props[2]=uno.createProperty("SortFields",     tableSortField       )

SAY "sleeping, then sorting descendingly first column, leaving first row as header alone..."
CALL syssleep 3

/* performe the sorting */
xRange~XSortable~sort(props)    -- perform the sorting

::requires UNO.CLS    -- get UNO support

