-- Example 16
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a blank *.sxc, fill it with data and show a database-operation (filtering)

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxc - file */
url = "private:factory/scalc"
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* insert some text */
CALL UNO.setCell xSheet, 0, 0, "Name"                      -- cell "A1"
CALL UNO.setCell xSheet, 1, 0, "Salary"                    -- cell "B1"

DO i=1 TO 10
	CALL UNO.setCell xSheet, 0, i, "Name"i             -- cell "A"i
	CALL UNO.setCell xSheet, 1, i, RANDOM(500, 3000)   -- cell "B"i
END

say "sleeping..."
CALL syssleep 3

/* create the CellRange to filter */
xRange      = xSheet~XCellRange~getCellRangeByName("A1:A11")
xFilter     = xRange~XSheetFilterableEx        -- get filter interface for range
xFilterDesc = xFilter~createFilterDescriptor(.true)

/* define the table filter fields */
CALL UNO.loadClass "com.sun.star.sheet.TableFilterField"
aFilterFields = bsf.createArray(.UNO~TableFilterField, 1)   -- create Java array
aFilterFields[1] = .UNO~TableFilterField~new
aFilterFields[1]~Field       = 1
aFilterFields[1]~IsNumeric   = .false
aFilterFields[1]~Operator    = bsf.getConstant("com.sun.star.sheet.FilterOperator", "GREATER_EQUAL")
aFilterFields[1]~StringValue = "2000"

xFilterDesc~setFilterFields(aFilterFields)

/* set the FilterProperties and filter */
xFilterProps = xFilterDesc~XPropertySet~setPropertyValue("ContainsHeader", box("boolean", .true))

say "now filtering: GREATER_EQUAL 2000..."
xFilter~filter(xFilterDesc)

::requires UNO.CLS    -- get UNO support