-- Example 17
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a blank *.sxc and set the CellStyle

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxc - file */
url = "private:factory/scalc"
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get the SpreadSheet you want to work with */
xDocument    = xCalcComponent~XSpreadSheetDocument

-- get first sheet in spreadsheet
xSheet = xDocument~getSheets~XIndexAccess~getByIndex(0)~XSpreadSheet

/* insert some text */
CALL UNO.setCell xSheet, 0, 0, "look at the cell style..."
say "sleeping..."
CALL syssleep 2

/* get the cell style container */
xFamiliesSupplier = xDocument~XStyleFamiliesSupplier
xCellStyle = xFamiliesSupplier~getStyleFamilies~getByName("CellStyles")~XNameContainer

/* create a new cell style */
xServiceManager = xDocument~XMultiServiceFactory
oCellStyle = xServiceManager~createInstance("com.sun.star.style.CellStyle")
xCellStyle~insertByName("MyNewCellStyle", oCellStyle)

/* modify properties of the new style */
xPropertySet = oCellStyle~XPropertySet
xPropertySet~setPropertyValue("CharWeight", box("float", bsf.getConstant("com.sun.star.awt.FontWeight", "BOLD")))
xPropertySet~setPropertyValue("CharColor",  box("int",   "ff 00 00"x ~c2d))

/* create a CellRange and set the PropertyStyle */
xCellRange = xSheet~getCellRangeByPosition(0, 0, 3, 3)
say "setting cell style..."
xCellRange~XPropertySet~setPropertyValue("CellStyle", "MyNewCellStyle")

::requires UNO.CLS    -- get UNO support