-- Example 18
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open an existing *.sxc - file and create a simple chart

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the *.sxc - file */
-- get the document from the current folder
url = ConvertToURL(directory()"/testnumbers.sxc")
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* create the frame for the Chart */
oRect = .bsf~new("com.sun.star.awt.Rectangle")
oRect~X      = 300
oRect~Y      = 5000
oRect~Width  = 18000
oRect~Height = 8000

/* catch the underlying data and make a CellRange*/
myRange=xSheet~XCellRange ~getCellRangeByName("A1:C10")
myAddr = myRange~XCellRangeAddressable~getRangeAddress

/* create the CellRangeAddress for the Chart */
CALL UNO.loadClass "com.sun.star.table.CellRangeAddress"
oAddr = bsf.createArray(.UNO~CellRangeAddress, 1)     -- create Java array
oAddr[1] = myAddr

/* get the Sheet's ChartsSupplier, add a new Chart */
xTableCharts = xSheet~XTableChartsSupplier~getCharts
xTableCharts~addNewByName("FirstChart", oRect, oAddr, .true, .true)

/* save the result - we need it for the next example */
storeURL = makeURL("charts.sxc")  -- save the document in the current folder
xCalcComponent~XStorable~storeAsURL(storeURL, .UNO~noProps)

::requires UNO.CLS    -- get UNO support

::routine makeUrl
  return  ConvertToURL(directory() || "\" || arg(1))