-- Example 19
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open an existing *.sxc - file, edit a chart and make a 3D-chart

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader

bDump=.true -- .false         -- if set to .true, then information about the UNO objects is queried and dumped
                                                       -- interface
/* open the blank *.sxc - file */
-- get the document from the current folder
url = ConvertToURL(directory()"/charts.sxc")
xCalcComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/*  trace results interactively, ---rgf, 2006-09-03
    trace ?r
*/

/* get first sheet in spreadsheet */
xSheet = xCalcComponent~XSpreadSheetDocument~getSheets~XIndexAccess~getByIndex(0) ~XSpreadSheet

/* get the Sheet's ChartsSupplier, get first chart */
xTableCharts = xSheet~XTableChartsSupplier~getCharts

if bDump=.true then
do
   say "xTableCharts:" ppd(uno.getDefinition(xTableCharts))
   say "xTableCharts-interfaces:" ppd(uno.getInterfaceNamesViaReflection(xTableCharts, .true))
   say "xTableCharts-XTypeProvider-interfaces:" ppd(uno.getXTypeProviderTypeNames(xTableCharts))
end

-- x1=xTableCharts~XNameAccess~getByName("FirstChart")
x1=xTableCharts~getByName("FirstChart")
if bDump=.true then
do
   say "x1:" ppd(uno.getDefinition(x1))
   say "x1-interfaces:" ppd(uno.getInterfaceNamesViaReflection(x1, .true))
end

x1=x1~XTableChart
if bDump=.true then
do
   say "x1:" ppd(uno.getDefinition(x1))
   say "x1-interfaces:" ppd(uno.getInterfaceNamesViaReflection(x1, .true))
end

-- xTableCharts is a SUBCLASS of XNameAccess !
xChart = xTableCharts~getByName("FirstChart")~XTableChart

/* get the embedded Object */
xComponent = xChart~XEmbeddedObjectSupplier~getEmbeddedObject

/* get the Diagram from the ChartDocument */
xDiagram = xComponent~XChartDocument~getDiagram

/* set the properties */
xPropsChart = xDiagram~XPropertySet
say "sleeping..."
CALL syssleep 2
xPropsChart~setPropertyValue("Dim3D", box("bool", .true))
say "sleeping..."
CALL syssleep 2
xPropsChart~setPropertyValue("Deep", box("bool", .true))
say "sleeping..."
CALL syssleep 2

say "---"
say ppd(xDiagram~uno.getDefinition)":"
say "---"
say "properties of XDiagram:" ppd(uno.getProperties(XDiagram))
say "---"
name="com.sun.star.chart.ChartSolidType"
say "constants" pp(name)":" ppd(uno.getDefinition(name))
say "---"

-- up to and including: 2.2.1, errs in 2.3.0 !!
-- xPropsChart~setPropertyValue("SolidType", box("INT", bsf.getConstant("com.sun.star.chart.ChartSolidType", "CYLINDER")))

-- 2.3.0: 
-- xPropsChart~setPropertyValue("SymbolType", box("INT", bsf.getConstant("com.sun.star.chart.ChartSolidType", "CYLINDER")))

do type over .list~of("RECTANGULAR_SOLID", "CYLINDER", "CONE", "PYRAMID")
   say "type:" type
   xPropsChart~setPropertyValue("SymbolType", box("INT", bsf.getConstant("com.sun.star.chart.ChartSolidType", type)))
   call SysSleep 2
end

if bDump then
do
   say "properties of XDiagram:" ppd(uno.getProperties(XDiagram))
   name="com.sun.star.chart.ChartSolidType"
   say "constants" pp(name)":" ppd(uno.getDefinition(name))
end


/* set the FloorProperties */
xPropsFloor = xDiagram~X3DDisplay~getFloor~XPropertySet
xPropsFloor~setPropertyValue("FillColor", box("int", "00 00 00"x ~c2d))
xPropsFloor~setPropertyValue("FillBackground", box("boolean", .true))

::requires UNO.CLS    -- get UNO support

