-- Example 20
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- open a blank *.sxc and set the CellStyle

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxd - file */
url = "private:factory/sdraw"
xDrawComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

-- need document's factory to be able to insert created objects
xDocumentFactory = xDrawComponent~XMultiServiceFactory

/* get draw page by index */
xDrawPage = xDrawComponent~XDrawPagesSupplier~getDrawPages~getByIndex(0)~XDrawPage

/* create a Rectangle and add it to the shape */
xShape = xDocumentFactory~createInstance("com.sun.star.drawing.RectangleShape") -
                         ~XShape
-- format the variables
shapeX = 3000
shapeY = 3000
xShape~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))

-- format the variables
shapeWidth  = 5000
shapeHeight = 2500
xShape~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))
xDrawPage~add(xShape)  -- add new shape to first draw page

/* now we can insert text into the rectangle */
xShape~XText~setString("Hello World!")

::requires UNO.CLS    -- get UNO support