-- Example 21
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- handling the properties of a shape and group 2 shapes

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxd - file */
url = "private:factory/sdraw"
xDrawComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)
xDocumentFactory = xDrawComponent~XMultiServiceFactory

/* get draw page by index */
xDrawPage = xDrawComponent~XDrawPagesSupplier~getDrawPages~getByIndex(0)~XDrawPage

/* create a Rectangle and add it to the shape */
shapeRectangle  = xDocumentFactory~createInstance("com.sun.star.drawing.RectangleShape")
xShapeRectangle = shapeRectangle~XShape

-- format the variables
shapeX = 3000
shapeY = 3000
xShapeRectangle~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))

-- format the variables
shapeWidth  = 5000
shapeHeight = 2500
xShapeRectangle~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))

xDrawPage~add(xShapeRectangle)  -- add shape to first draw page

/* set the properties of the rectangle shape */
xShapeProps = xShapeRectangle~XPropertySet

-- set the CornerRadius
xShapeProps~setPropertyValue("CornerRadius", box("int", 1000))

-- set the Shadow
xShapeProps~setPropertyValue("Shadow", box("boolean", .true))
xShapeProps~setPropertyValue("ShadowXDistance", box("int", 250))
xShapeProps~setPropertyValue("ShadowYDistance", box("int", 250))

-- and set the Colors
xShapeProps~setPropertyValue("FillColor", box("int", "ff 00 ff"x ~c2d))
xShapeProps~setPropertyValue("LineColor", box("int", "00 00 ff"x ~c2d))

-- set the Rotation
say "sleeping..."
CALL syssleep 2
xShapeProps~setPropertyValue("ShearAngle", box("int", 1000))
say "sleeping... (after setting ShearAngle)"
CALL syssleep 2
xShapeProps~setPropertyValue("RotateAngle", box("int", 1000))
say "sleeping... (after setting RotateAngle)"
CALL syssleep 2

/* insert another shape */
shapeEllipse = xDocumentFactory~createInstance("com.sun.star.drawing.EllipseShape")
xShapeEllipse = shapeEllipse~XShape

shapeX = 3500
shapeY = 3500
xShapeEllipse~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))
shapeWidth  = 2000
shapeHeight = 2000
xShapeEllipse~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))

xDrawPage~add(xShapeEllipse)

/* now group the 2 shapes */
-- get ShapeCollection from the XMultiComponentFactory
xObj = xMcf~createInstanceWithContext("com.sun.star.drawing.ShapeCollection", xContext)
xToGroup = xObj~XShapes
xToGroup~add(xShapeRectangle)
xToGroup~add(xShapeEllipse)
xShapeGrouper = xDrawPage~xShapeGrouper
xShapeGroup = xShapeGrouper~group(xToGroup)

/* so we can move both shapes at once */
say "sleeping, about to move both shapes at once..."
CALL syssleep 2
shapeX = 5000
shapeY = 5000
xShapeGroup~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))

::requires UNO.CLS    -- get UNO support