-- Example 22
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- handling the properties of a shape and group 2 shapes

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxd - file */
url = "private:factory/sdraw"
xDrawComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)
xDocumentFactory = xDrawComponent~XMultiServiceFactory

/* get draw page by index */
xDrawPage = xDrawComponent~XDrawPagesSupplier~getDrawPages~getByIndex(0)~XDrawPage

/* create a Rectangle and add it to the shape */
shapeRectangle = -
	xDocumentFactory~createInstance("com.sun.star.drawing.RectangleShape")
xShapeRectangle = shapeRectangle~XShape

-- set the position
shapeX = 0
shapeY = 0
xShapeRectangle~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))

-- set the size
shapeWidth  = 21000
shapeHeight = 8000
xShapeRectangle~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))

-- add the Rectangle to the DrawPage
xDrawPage~add(xShapeRectangle)

/* set the properties of the rectangle shape */
xShapeProps = xShapeRectangle~XPropertySet

-- set the Colors
xShapeProps~setPropertyValue("FillColor", box("int", "ff 00 ff"x ~c2d))
xShapeProps~setPropertyValue("LineColor", box("int", "00 00 ff"x ~c2d))

oGradient = .bsf~new("com.sun.star.awt.Gradient")
oGradient~Style = bsf.getConstant("com.sun.star.awt.GradientStyle", "LINEAR")
oGradient~StartColor     = 95847395
oGradient~EndColor       = 23123123
oGradient~Angle          = 450
oGradient~Border         = 0
oGradient~XOffset        = 0
oGradient~YOffset        = 0
oGradient~StartIntensity = 100
oGradient~EndIntensity   = 100
oGradient~StepCount      = 10

xShapeProps~setPropertyValue("FillStyle",    bsf.getConstant("com.sun.star.drawing.FillStyle", "GRADIENT"))
xShapeProps~setPropertyValue("FillGradient", oGradient)

-- and set the Text
xShapeProps~setPropertyValue("TextFitToSize", -
	bsf.getConstant("com.sun.star.drawing.TextFitToSizeType", "PROPORTIONAL"))

xShapeProps~setPropertyValue("TextLeftDistance",  box("int", 2500))
xShapeProps~setPropertyValue("TextRightDistance", box("int", 2500))
xShapeProps~setPropertyValue("TextUpperDistance", box("int", 2500))
xShapeProps~setPropertyValue("TextLowerDistance", box("int", 2500))

xText = xShapeRectangle~XText
xTextCursor = xText~createTextCursor
xTextCursor~gotoEnd(.false)
xTextRange = xTextCursor~XTextRange
xTextRange~setString("using TextFitToSize")
say "sleeping..."
CALL sysSleep 2

xTextProps = xTextRange~XPropertySet
xTextProps~setPropertyValue("ParaAdjust", bsf.getConstant("com.sun.star.style.ParagraphAdjust", "CENTER"))
xTextProps~setPropertyValue("CharColor",  box("int", "ff 00 00"x ~c2d))

xText~insertControlCharacter(xTextCursor, -
         bsf.getConstant("com.sun.star.text.ControlCharacter", "PARAGRAPH_BREAK"), .false)

xTextRange~setString("and a Border distance of 25mm")

::requires UNO.CLS    -- get UNO support

