-- Example 23
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- Open an existing drawpage from the internet and export each page to a *.jpg
-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the sdraw-file  */
-- get the document from the current folder
url = ConvertToURL(directory()"/drawpage01.sxd")
xDrawComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* create and set the filter */
-- get GraphicExportFilter from the XMultiComponentFactory
xGraphicExportFilter = xMcf~createInstanceWithContext("com.sun.star.drawing.GraphicExportFilter", xContext)
xExporter = xGraphicExportFilter~XExporter   -- get the exporter interface
xFilter   = xGraphicExportFilter~XFilter     -- get the filter interface

/* create filter properties and filter it*/
filterprops = bsf.createArray(.UNO~propertyValue, 2)  -- create Java array
filterProps[1]=uno.createProperty("MediaType", "image/jpeg")
filterProps[2]=uno.createProperty("URL",       .nil)  -- storeURL, will be set in loop below

/* with the XDrawPagesSupplier we can use other page-methods */
drawPages = xDrawComponent~XDrawPagesSupplier~getDrawPages
count = drawPages~getCount()
filename = directory()"\export" -- base filename for JPEGs to be created

DO i=1 to count         -- iterate over pages
	SAY "Converting " i "of" count "page(s)..."

	xComp = drawPages~getByIndex(i-1)~XComponent --get the page by 0-based index
	xExporter~setSourceDocument(xComp)
	-- define filename
	filterprops[2]~Value = ConvertToURL(filename || i || ".jpg")
	xFilter~filter(filterprops)   -- now carry out the conversion ("filtering")
END

xDrawComponent~dispose  -- close the document

::requires UNO.CLS      -- get UNO support