-- Example 25
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- make a short presentation

-- Retrieve the Desktop object, we need its XComponentLoader interface to load
-- a new document
oDesktop         = UNO.createDesktop()    -- get the UNO Desktop service object
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader
                                                       -- interface
/* open the blank *.sxi - file */
url = "private:factory/simpress"
xImpressComponent = xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)
-- need document's factory to be able to insert created objects
xImpressFactory = xImpressComponent~XMultiServiceFactory

/* get draw page by index */
xDrawPagesSupplier = xImpressComponent~XDrawPagesSupplier
xDrawPages = xDrawPagesSupplier~getDrawPages
xDrawPage0 = xDrawPages~getByIndex(0)~XDrawPage

/* set the properties to animate the first object automatically */
xDrawPage0Props = xDrawPage0~XPropertySet
xDrawPage0Props~setPropertyValue("Change", box("int", 2))
xDrawPages~insertNewByIndex(1)
xDrawPage1 = xDrawPages~getByIndex(1)~XDrawPage

/* create a Rectangle and add it to the DrawPage0 */
shapeRectAngle = xImpressFactory~createInstance("com.sun.star.drawing.RectangleShape")
shapeRectAngle = shapeRectAngle~XShape
shapeX = 3000
shapeY = 3000
shapeRectAngle~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))
shapeWidth  = 10000
shapeHeight = 3000
shapeRectAngle~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))
xDrawPage0~add(shapeRectAngle)
shapeRectAngle~XText~setString("Click anywhere to go on!")

/* create a Rectangle and add it to the DrawPage1 */
shapeEllipse = xImpressFactory~createInstance("com.sun.star.drawing.EllipseShape")
xShapeEllipse = shapeEllipse~XShape
shapeX = 3000
shapeY = 3000
xShapeEllipse~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, shapeY))
shapeWidth  = 9000
shapeHeight = 3000
xShapeEllipse~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))
xDrawPage1~add(xShapeEllipse)
xShapeEllipse~XText~setString("Click here to go back!")

/* set the Animation for the Rectangle on the first page */
xRectangleProps = shapeRectAngle~XPropertySet
xRectangleProps~setPropertyValue("Effect", -
	bsf.getConstant("com.sun.star.presentation.AnimationEffect", "WAVYLINE_FROM_BOTTOM"))

/* set the slide transition effect for the second page */
xSlideProps = xDrawPage1~XPropertySet
xSlideProps~setPropertyValue("Effect", bsf.getConstant("com.sun.star.presentation.FadeEffect", "RANDOM"))
xSlideProps~setPropertyValue("Speed",  bsf.getConstant("com.sun.star.presentation.AnimationSpeed", "MEDIUM"))

/* set the Interaction of the Ellipse on the 2nd Page */
xEllipseProps = shapeEllipse~XPropertySet
xEllipseProps~setPropertyValue("OnClick", bsf.getConstant("com.sun.star.presentation.ClickAction", "FIRSTPAGE"))

/* start the presentation */
xPresentation = xImpressComponent~XPresentationSupplier~getPresentation
-- "start" is a method in the ooRexx class "Object", hence using
-- "bsf.invoke()" to dispatch "start" on the Java side
xPresentation~bsf.invoke("start")

::requires UNO.CLS    -- get UNO support