-- Example 26
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- read data from an existing database

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

-- first we create our RowSet object and get its XRowSet interface
oRowSet = xMcf~createInstanceWithContext("com.sun.star.sdbc.RowSet", xContext)
xRowSet = oRowSet~XRowSet

-- set the properties needed to connect to a database
xProp = xRowSet~XPropertySet

-- the DataSourceName can be a data source registered with [PRODUCTNAME],
-- among other possibilities
xProp~setPropertyValue("DataSourceName", "Bibliography")

-- the CommandType must be TABLE, QUERY or COMMAND - here we use COMMAND
xProp~setPropertyValue("CommandType", box("int", bsf.getStaticValue("com.sun.star.sdb.CommandType", "COMMAND")))

-- the Command could be a table or query name or a SQL command, depending on
-- the CommandType
xProp~setPropertyValue("Command", "SELECT IDENTIFIER, AUTHOR FROM biblio ORDER BY IDENTIFIER")

-- if your database requires logon, you can use the properties User and Password
-- xProp~setPropertyValue("User", "username")
-- xProp~setPropertyValue("Password", "password")

xRowSet~execute

-- prepare the XRow interface for column access
xRow = oRowSet~XRow

SAY "Identifier | Author"
SAY "-------------------"

DO WHILE xRowSet~next > 0
	ident  = xRow~getString(1)
	author = xRow~getString(2)
	say ident "-" author
END

::requires UNO.CLS    -- get UNO support