-- Example 27
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- connect to an existing MS-Access database

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

/* get the DriverManager */
oDriverManager = xMcf~createInstanceWithContext("com.sun.star.sdbc.DriverManager", xContext)
xDriverManager = oDriverManager~XDriverManager

/* define the database - URL (you need to define this via ODBC for the local Access file
   "database.mdb", cf. Ahammer's documentation retrievable via the above URL) */
url = "jdbc:odbc:database"

/* set the properties connection */
props = bsf.createArray(.UNO~PropertyValue, 1)     -- create Java array
props[1] = .UNO~PropertyValue~new
props[1]~Name  = "JavaDriverClass"
props[1]~Value = "sun.jdbc.odbc.JdbcOdbcDriver"

/* settle up the connection */
xConnection = xDriverManager~getConnectionWithInfo(url, props)
xStatement = xConnection~createStatement

/* show the content of the database */
call printtable xStatement

::requires UNO.CLS    -- get UNO support

-- a function to print the content of the database

::routine printtable

  use arg xStatement

  query = "SELECT number, name FROM members"
  xResult = xStatement~executeQuery(query)
  xRow = xResult~XRow

  do while xResult~next > 0
  	 number = xRow~getString(1)
  	 name = xRow~getString(2)
  	 say number"." name
  end