/*
   Example 28
   From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
   use a MySQL-database

   NOTE:

      This example will only work if you have a MySQL database
      running on port 3306 named "Test" with an appropriate setup
      and correct tables! Furthermore the class
      "org.gjt.mm.mysql.Driver" has to be installed!

-- changed: 2008-07-21, Rony G. Flatscher: using new public routine "uno.createProperty()"
*/

/* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

/* get the DriverManager */
oDriverManager = xMcf~createInstanceWithContext("com.sun.star.sdbc.DriverManager", xContext)
xDriverManager = oDriverManager~XDriverManager

/* define the database - URL */
url = "jdbc:mysql://localhost:3306/test"

/* set the properties connection */
props = bsf.createArray(.UNO~PropertyValue, 3)     -- create Java array
props[1]=uno.createProperty("user",            "root")
props[2]=uno.createProperty("password",        "")
props[3]=uno.createProperty("JavaDriverClass", "org.gjt.mm.mysql.Driver")

/* settle up the connection */
xConnection = xDriverManager~getConnectionWithInfo(url, props)
xStatement = xConnection~createStatement

/* create and show the table */
SAY "create table..."
query = "CREATE TABLE testtable (number INTEGER, firstname VARCHAR(30), lastname VARCHAR(30), age INTEGER)"
say "insert some data..."
xStatement~executeUpdate(query)

query = "INSERT INTO testtable VALUES (1, 'Andreas', 'Ahammer', 23)"
xStatement~executeUpdate(query)

query = "INSERT INTO testtable VALUES (2, 'Wolfgang', 'Schober', 22)"
xStatement~executeUpdate(query)

SAY "data from 'TestTable'"
CALL printtable xStatement

SAY "insert new data..."
query = "INSERT INTO testtable VALUES (3, 'Roman', 'Dietler', 27)"
xStatement~executeUpdate(query)

say "new data from 'TestTable'"
call printtable xStatement

/* delete table */
query = "DROP TABLE testtable"
xStatement~executeUpdate(query)
SAY "table deleted..."

::requires UNO.CLS    -- get UNO support

-- A function to show the content of the table

::routine printtable

  use arg xStatement

  query = "SELECT number, firstname, lastname, age FROM testtable"
  xResult = xStatement~executeQuery(query)
  xRow = xResult~XRow

  DO WHILE xResult~next > 0
  	number = xRow~getString(1)
  	firstname = xRow~getString(2)
  	lastname = xRow~getString(3)
  	age = xRow~getString(4)
  	say "  " || number || " - " lastname || " " || firstname || ", " || age
  END

/*
   NOTE:
   This example will only work if you have a MySQL database
   running on port 3306 named "Test" with an appropriate setup
   and correct tables! Furthermore the class
   "org.gjt.mm.mysql.Driver" has to be installed!
*/