-- Example 29
-- From Ahammer, Andreas: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07>
-- use the SpellChecker to check a word

   /* initialize connection to server, get XContext */
xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

SAY "*********************"
SAY "*** Spell Checker ***"
SAY "*********************"

SAY "Please enter a word: "
parse pull aWord              -- get word to spell check
SAY

   /* create the LinguServiceManager and the SpellChecker */
mxLinguSvcMgrName = xMcf~createInstanceWithContext("com.sun.star.linguistic2.LinguServiceManager", xContext)
xSpellChecker = mxLinguSvcMgrName~XLinguServiceManager~getSpellChecker

   /* load the required class "com.sun.star.lang.Locale" and set the language to US-english */
CALL UNO.loadClass "com.sun.star.lang.Locale"
aLocale = .UNO~Locale~new("en", "US", "")    -- get the American English locale

   /* test the word if it is valid */
isCorrect = xSpellChecker~isValid(aWord, aLocale, .UNO~noProps)

wordCorrect = ""
IF isCorrect = 0 THEN wordCorrect = "NOT"

say "The word '"aWord"' is" wordCorrect "correct!"

   /* if the word is not correct submit all alternatives */
xSpellAlternatives = xSpellChecker~spell(aWord, aLocale, .UNO~noProps)

IF xSpellAlternatives <> .nil THEN
DO
   SAY
   SAY "Alternatives: "
   DO alternative OVER xSpellAlternatives~getAlternatives
      SAY "  " || alternative
   END
END

::requires UNO.CLS    -- get UNO support
