/* After Ahammer, Andreas' example # 29: <http://wi.wu-wien.ac.at/rgf/diplomarbeiten/index.html#bakk_07> */

   /* initialize connection to server, get ctxt */
ctxt = UNO.connect()          /* connect to server and retrieve the ctxt object  */
sm   = ctxt~getServiceManager /* retrieve XMultiComponentFactory                 */

say "*********************"
say "*** Spell Checker ***"
say "*********************"
say "Please enter a word: "
parse pull aWord              /* get word to spell check from user   */
say

   /* create the LinguServiceManager and the SpellChecker */
lsm = sm~createInstanceWithContext("com.sun.star.linguistic2.LinguServiceManager", ctxt)
sc  = lsm~XLinguServiceManager~getSpellChecker

   /* load the required class "com.sun.star.lang.Locale" and set the language to US-english */
call uno.loadClass "com.sun.star.lang.Locale"
aLocale = .uno~Locale~new("en", "US", "")

isCorrect = sc~isValid(aWord, aLocale, .UNO~noProps)  /* test the word  */
say "The word" pp(aWord) "is" iif(isCorrect, "", "NOT") "correct!"

   /* if the word is not correct submit all alternatives */
sa = sc~spell(aWord, aLocale, .uno~noProps)

if sa <> .nil then
do
   say
   say "Alternatives: "
   do alternative over sa~alternatives
      say "  " alternative
   end
end

::requires UNO.CLS   -- get UNO support

::routine pp         -- return argument enclosed in square brackets
  parse arg text
  return "["text"]"
