/*NOTE! This example is tested with Thunderbird and Windows XP */
xScriptContext = uno.getScriptContext() -- wrap first argument into an UNO-proxy object

oDesktop=xScriptContext~getDesktop -- get the desktop (an XDesktop object)
oContext=xScriptContext~getComponentContext  
                              -- get the context(an XComponentContext object)
/*get xMultiComponentFactory*/
xMcf = oContext~getServiceManager

xComponentLoader=oDesktop~XDesktop~XComponentLoader -- get componentLoader interface

/* open the blank *.sxw - file */
url = "private:factory/swriter"
xWriterComponent=xComponentLoader~loadComponentFromURL(url, "_blank", 0, .UNO~noProps)

/* create the TextObject and the TextCursor */
xTextDocument = xWriterComponent~XTextDocument
xText = XTextDocument~getText
xTextCursor = xText~createTextCursor

/*design a document*/
/*create TextFields to insert date and time*/
xDmsf = xTextDocument~xMultiServiceFactory
xTextFieldTime1 = xDMsf~createInstance("com.sun.star.text.TextField.DateTime") -
	~xTextField
xTextFieldTime2 = xDMsf~createInstance("com.sun.star.text.TextField.DateTime") -
	~xTextField
xTextFieldTime1~XPropertySet~setPropertyValue("IsDate", box("boolean", .true))

xText~insertString(xTextCursor,"This is an attachement sent from Martin, ", .false)
xText~insertTextContent(xTextCursor, xTextFieldTime1, .false)
xText~insertString(xTextCursor, " at ", .false)
xText~insertTextContent(xTextCursor, xTextFieldTime2, .false)

/*save the document*/
xWriterComponent~xStorable~storeAsURL("file:///c:/attachement.odt", .UNO~noProps)

/*create xSimpleMailClient(for sending) and SimpleMailMessage(for adding Subject, Recipient and Attachement)*/

SimpleMailSystem=xMcf~ -
	createInstancewithContext("com.sun.star.system.SimpleSystemMail", oContext)

XSimpleMailClientSupplier = SimpleMailSystem~XSimpleMailClientSupplier
XSimpleMailClient = XSimpleMailClientSupplier~querySimpleMailClient
mail = XSimpleMailClient~createSimpleMailMessage

/*set Recipient and Subject*/
mail~setRecipient("h0251293@wu-wien.ac.at")
mail~setSubject("mail from OpenOffice.org 2.0")

/*setAttachement*/
attach = bsf.createArray(.bsf4rexx~string.class, 1)
attach[1] = "file:///c:/attachement.odt"
mail~setAttachement(attach)

flag=bsf.getConstant("com.sun.star.system.SimpleMailClientFlags", "NO_USER_INTERFACE")

XsimpleMailClient~sendSimpleMailMessage(mail, flag)

::requires UNO.CLS   -- load UNO support for OpenOffice.org