xScriptContext = uno.getScriptContext() -- wrap first argument into an UNO-proxy object

oDesktop=xScriptContext~getDesktop -- get the desktop (an XDesktop object)

-- Retrieve the Desktop object, we need its XComponentLoader interface to load 
-- a new document
xComponentLoader = oDesktop~XDesktop~XComponentLoader  -- get componentLoader interface

/* open the blank *.sxw - file */
url = "private:factory/simpress"
xImpressComponent = xComponentLoader~loadComponentFromURL(url, "_blank",0,.UNO~noProps)

-- need document's factory to be able to insert created objects
xImprFactory = xImpressComponent~XMultiServiceFactory

/*creating a master Page*/
xMasterPagesSupplier = xImpressComponent~XMasterPagesSupplier
xMasterPages = xMasterPagesSupplier~getMasterPages
xMasterPage = xMasterPages~getByIndex(0)~XDrawPage

/*create a GraphicObjectShape with picture*/
oGraph = xImprFactory~createInstance("com.sun.star.drawing.GraphicObjectShape")
xGraph = oGraph~xShape
xGraph = setshape(xGraph, 2500, 8000, 1000, 1000)
xPropertySet = xGraph~xPropertySet
xPropertySet~setPropertyValue("GraphicURL", "file:///C:/OpenOffice.org_02.jpg")

oGraph = xImprFactory~createInstance("com.sun.star.drawing.TextShape")
xGraph4 = oGraph~xShape
xGraph4 = setshape(xGraph4, 1800, 21000, 4500, 9500)
props4 = xGraph4~xPropertySet
constant = bsf.getConstant("com.sun.star.drawing.TextFitToSizeType", "PROPORTIONAL")
props4~setPropertyValue("TextFitToSize", constant)

xMasterPage~add(xGraph4)

graphtext = xGraph4~xText
graphtext~setString("This is the Master Slide")

xMasterPage~add(xGraph)

xTFP=xImprFactory~createInstance("com.sun.star.text.TextField.PageNumber")~XTextField

oGraph = xImprFactory~createInstance("com.sun.star.drawing.TextShape")
xGraph3 = oGraph~xShape
xGraph4 = setshape(xGraph3, 5000, 5000, 23000, 19000)
graphtext3 = xGraph3~xText
xMasterPage~add(xGraph3)
TextCursor = graphtext3~createTextCursor
graphtext3~insertString(TextCursor, "Folie Nr.: ", .false)
graphtext3~insertTextContent(TextCursor, xTFP, .false)

/*Inserting Text Shapes into documents*/
xDrawPagesSupplier = xImpressComponent~XDrawPagesSupplier
xDrawPages = xDrawPagesSupplier~getDrawPages
xDrawPage0 = xDrawPages~insertNewByIndex(0)~XDrawPage
xSlideProps = xDrawPage0~xPropertySet
constant = bsf.getConstant("com.sun.star.presentation.FadeEffect",  "RANDOM")
xSlideProps~setPropertyValue("Effect", constant)

constant = bsf.getConstant("com.sun.star.presentation.AnimationSpeed", "MEDIUM")
xSlideProps~setPropertyValue("Speed", constant)

oGraph = xImprFactory~createInstance("com.sun.star.drawing.TextShape")
xGraph5 = oGraph~xShape
xGraph5 = setshape(xGraph5, 1800, 21000, 4000, 8000)
props = xGraph5~xPropertySet
constant = bsf.getConstant("com.sun.star.drawing.TextFitToSizeType", "PROPORTIONAL")
props~setPropertyValue("TextFitToSize", constant)

xDrawPage0~add(xGraph5)

graphtext = xGraph5~xText
graphtext~setString("This is an example DrawPage")

/* start the presentation */
xPresentation = xImpressComponent~XPresentationSupplier~getPresentation
-- "start" is a method in ooRexx class "Object", hence using message
-- "bsf.invoke()" to dispatch "start" on the Java sid
xPresentation~bsf.invoke("start")

::requires UNO.CLS   -- load UNO support for OpenOffice.org

::routine setshape

use arg xGraph, h, w, x, y
size = .bsf~new("com.sun.star.awt.Size")
point = .bsf~new("com.sun.star.awt.Point")
size~Height = h
size~Width = w
point~x = x
point~y= y
xGraph~setPosition(point)
xGraph~setSize(size)

return xGraph
