xScriptContext = uno.getScriptContext() -- wrap first argument into an UNO-proxy object

xContext=xScriptContext~getComponentContext 
                                 -- get the context(an XComponentContext object)

XMcf = xContext~getServiceManager -- retrieve XMultiComponentFactory

-- first we create our RowSet object and get its XRowSet interface
oRowSet = xMcf~createInstanceWithContext("com.sun.star.sdbc.RowSet", xContext)
xRowSet = oRowSet~XRowSet

-- set the properties needed to connect to a database
xProp = xRowSet~XPropertySet

-- the DataSourceName can be a data source registered with [PRODUCTNAME],
-- among other possibilities
xProp~setPropertyValue("DataSourceName", "addresses")

-- the CommandType must be TABLE, QUERY or COMMAND - here we use COMMAND
xProp~setPropertyValue("CommandType", -
     box("int", bsf.getStaticValue("com.sun.star.sdb.CommandType", "COMMAND")))

-- the Command could be a table or query name or a SQL command, depending on
-- the CommandType
xProp~setPropertyValue("Command", 'SELECT' ' "E-mail" ' 'FROM addressmozilla' )

xRowSet~execute -- prepare the XRow interface for column access

xRow = oRowSet~XRow

/*sending e-mail to every address listed in the table addressmozilla*/
SimpleMailSystem=XMcf -
~createInstancewithContext("com.sun.star.system.SimpleSystemMail", xContext)
XSimpleMailClientSupplier = SimpleMailSystem~XSimpleMailClientSupplier
XSimpleMailClient = XSimpleMailClientSupplier~querySimpleMailClient
con = bsf.getConstant("com.sun.star.system.SimpleMailClientFlags", "NO_USER_INTERFACE")

DO WHILE xRowSet~next > 0

        email = xRow~getString(1)
        mail = XSimpleMailClient~createSimpleMailMessage
        /*set Recipient and Subject*/
        mail~setRecipient(email)
        mail~setSubject("mail from OpenOffice.org 2.0")
        XsimpleMailClient~sendSimpleMailMessage(mail, con)
END

::requires UNO.CLS   -- load UNO support for OpenOffice.org