/*
   name:    getUserDirectory.rex
   author:  Rony G. Flatscher
   date:    2007-07-26
   remarks: transcribed from a BASIC code snippet to ooRexx, original e-mail:

               Reply-To: dev@framework.openoffice.org
               To: dev@framework.openoffice.org
               Path: not-for-mail
               From: Carsten Driesner <carsten.driesner@sun.com>
               Newsgroups: openoffice.framework.dev
               Date: Thu, 26 Jul 2007 16:41:46 +0200
               Organization: StarOffice / Sun Microsystems, Inc.
               Lines: 30
               In-Reply-To: <openoffice.framework.dev-46A86C67.70506@ch2000.com.cn>
               Subject: Re: [framework-dev] How to retrieve the user's directory?

               Liang Weike wrote:
               > Hello Carsten,
               >
               > I think the imported images should be stored in user's folder. In order
               > to get the directory I find a interface named
               > "XOfficeInstallationDirectories". Is it available to me? Or do you have
               > another specified directory to save the user's images?
               >
               Hi Liang Weike,

               XOfficeInstallationDirectories is not the correct interface for you. You
               should use the path settings service to retrieve the folder of the user.
               See the following Basic script which retrieves the "UserConfig" path and
               extends it to create the path to store the user imported images.

               REM  *****  BASIC  *****

               Sub Main
                  oPathSettings = createUnoService( "com.sun.star.util.PathSettings" )
                  oUserConfigPath = oPathSettings.getPropertyValue( "UserConfig" )
                  oChar = Right( oUserConfigPath, 1 )
                  if ( oChar <> "/" ) then
                    oUserConfigPath = oUserConfigPath + "/"
                  end if
                  oUserConfigPath = oUserConfigPath + "soffice.cfg/import/images"
                  msgbox oUserConfigPath
               End Sub

               Regards,
               Carsten
*/

-- rgf, 2007-07-26, 2008-09-13

xContext = UNO.connect()  -- connect to server and retrieve the XContext object
XMcf = xContext~getServiceManager   -- retrieve XMultiComponentFactory

oPathSettings=XMcf~createInstanceWithContext("com.sun.star.util.PathSettings", xContext)

say ppd(oPathSettings~uno.getDefinition)

oUserConfigPath = oPathSettings~XPropertySet~getPropertyValue( "UserConfig" )

s1="URL (canonical): userConfigPath="pp(oUserConfigPath)
s2="opsys-dependent: userConfigPath="pp(uno.convertFromUrl(oUserConfigPath))

say
say s1
say s2

.bsf.dialog~messageBox(s1 || .endOfLine || s2, "User Configuration Path", "info")

::requires uno.cls
