#!/usr/bin/rexx
/*
    name:      PrintTest.rex
    purpose:   show viewing and printing Java and Rexx files
    author:    Rony G. Flatscher
    date:      2006-01-17
    changed:   2006-01-20, ---rgf, now using a filter (this does not work under Windows!)
               2008-07-13, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                                   remove the first three chars from its result string)
               2008-07-19, rgf, added hash-bang line at the top

    remarks:   adapted from an adapted Java program named "TestPrint.java" from
               Zukowski, J.: "Java AWT Reference", O'Reilly & Associates, 1997 and
               spotted by Lee Pedin

    last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2006-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/


  f = .bsf~new("java.awt.Frame", "File Loader")    -- create instance of Frame
  f~bsf.addEventListener("window", "windowClosing", ".bsf~bsf.exit") -- if close icon on frame window is pressed

  statusInfo=.bsf~new("java.awt.Label")            -- create instance of Label
  f~add(statusInfo, "North");                      -- add label to frame

  p = .bsf~new("java.awt.Panel");                  -- create a panel
  .bsf~bsf.import("java.awt.Button", "javaButton") -- import Button class, make it available as .Button in Rexx
  loadButton=.javaButton~new("Load")               -- create a button
                                                   -- if button is pressed, load a file to textArea
  loadButton~bsf.addEventListener("action", "", "call loadFileCommand f, statusInfo, textArea")
  p~add(loadButton)                                -- add button to panel

  printButton=.javaButton~new("Print")             -- create a button
  printButton~bsf.addEventListener("action", "", "call printCommand f, textArea, props")
  p~add(printButton)                               -- add button to panel

  closeButton=.javaButton~new("Close")             -- create a button
  closeButton~bsf.addEventListener("action", "", ".bsf~bsf.exit")  -- if button is pressed, close app
  p~add(closeButton)                               -- add button to panel

  f~add(p, "South")                                -- add panel to south (bottom) of frame

  textArea=.bsf~new("java.awt.TextArea", 30, 100)  -- create a textArea
  f~add(textArea, "Center")                        -- add text area to center (middle) of frame
                                                   -- set specific font for textArea
  textArea~setFont(.bsf~new("java.awt.Font", "Courier", bsf.getStaticValue("java.awt.Font", "PLAIN"), 12))

  f~~pack~~show                                    -- calc layout, show frame

  do forever
     txt = bsf.pollEventText()                    --  wait for an eventText to be sent
     say "received the following eventText: ["txt"]"
     interpret txt                                 -- execute as a Rexx program
     if result= "SHUTDOWN, REXX !" then leave      -- JVM will be shutdown in 1/10sec
  end
  exit


  /* a procedure to be invoked if the appropriate button is pressed  */
  loadFileCommand: procedure
     use arg frame, statusInfo, textArea           -- retrieve Java object proxies
     file=.bsf~new("java.awt.FileDialog", frame, "Load File", bsf.getStaticValue("java.awt.FileDialog", "LOAD"))

     filter=.bsf~new('org.oorexx.misc.RgfFilter', '*rex;*java')  -- create a new filter
     filter~~addExtension('rex')~~addExtension('java')
     file~setFilenameFilter(filter)              -- set the filter to fileDialog

     file~setDirectory(directory())                -- set the directory to current directory
     file~show                                     -- show dialog, blocks until user entered something
     curFile=file~getFile                          -- get chosen file
     if curFile<>.nil then                         -- if a file was given, process it
     do
        filename=file~getDirectory || curFile      -- create a fully qualified file name
        statusInfo~setText("Load:" filename)       -- show filename to be loaded

        filesize=stream(filename, "C", "query size")  -- get file-size (returns empty string, if file does not exist)
        if filesize<>"" then
        do
           textArea~setText(charin(filename, 1, filesize))  -- read file and place it into textArea
           call stream filename, "c", "close"      -- close file
        end
        else
           textArea~setText("File Not Found:" filename)
     end
     return


::requires bsf.cls                  -- get BSF4Rexx (Java) support


  /* a routine to be invoked if the appropriate button is pressed    */
::routine printCommand
   use arg frame, textArea          -- retrieve Java proxy objects

   props=.bsf~new("java.util.Properties")           -- create an instance of Properties
   pjob=frame~getToolkit~getPrintJob(frame, "Cool Stuff", props)  -- get printer from user
   if pjob<>.nil then
   do
      pg=pjob~getGraphics
      if pg<>.nil then
      do
         call printLongString pjob, pg, textArea~getText -- print the string in the textArea
         pg~dispose
      end
      pjob~end
   end
   return


printLongString: procedure          /* this procedure carries out the printing   */
     use arg pjob, pg, s

      -- initialize variables
     margin = 36     -- 1/2 inch
     parse value "1 0 0" with pageNum linesForThisPage linesForThisJob

     pageHeight = pjob~getPageDimension~height - margin
     font="java.awt.Font"                          -- name of the Font class
     helv = .bsf~new(font, "Courier", bsf.getStaticValue(font, "PLAIN"), 8)
     pg~setFont(helv)                              -- set the font to the print graphic context
     fm = pg~getFontMetrics(helv)                  -- now font metrics reflect the printer ones
     fontHeight  = fm~getHeight                    -- get fontHeight
     fontDescent = fm~getDescent                   -- get fontDescent
     curHeight   = margin                          -- distance from top (margin initially)

     cr="0d"x                                      -- CR
     lf="0a"x                                      -- LF
     parse var s (lf) -1 n +1 -- get character immediately before LF, use CR-LF or LF sequence of text file
     if n=cr then nl=cr||lf
             else nl=lf

     do while s<>""
        parse var s nextLine (nl) s                -- extract a line

        if (curHeight+fontHeight)>pageHeight then  -- new page needed
        do
           say linesForThisPage "lines printed for page" pageNum
           if linesForThisPage=0 then
           do
              say "Font is too big for pages of this size; aborting ..."
              leave
           end
           pageNum=pageNum+1
           linesForThisPage=0
           pg~dispose
           pg=pjob~getGraphics
           if pg<>.nil then
           do
              pg~setFont(helv)
           end
           curHeight=margin
        end

        curHeight=curHeight+fontHeight
        if pg<>.nil then
        do
           pg~drawString(nextLine, margin, curHeight-fontDescent) -- string, x, y co-ordinates
           linesForThisPage=linesForThisPage+1
           linesForThisJob =linesForThisJob+1
        end
        else
           say "pg .nil"
     end

     say linesForThisPage "lines printed for page" pageNum
     say "pages printed:" pageNum
     say "total lines printed:" linesForThisJob
     return

