#!/usr/bin/rexx
/*
   Name:    "ShootOut.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in ShootOut.rex"
                or
            "java org.apache.bsf.Main            -in ShootOut.rex"
                or
            "rexxj ShootOut.rex" (Windows)
                or
            "rexxj.sh ShootOut.rex" (Unix)
                or
            "rexx ShootOut.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

   Needs:    ooRexx, BSF4Rexx

   Date:    2001-04-21, 2003-05-10, 2005-06-05
            2005-12-28, added Apache license

   Author:   Rony G. Flatscher, WU Wien University,

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   Changed:

            2008-07-13, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                                remove the first three chars from its result string)

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------

*/

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."


        /* bsf.import Java classes          */
.bsf~bsf.import("java.awt.Button"            , "awtButton"         )
.bsf~bsf.import('java.awt.Frame'             , "awtFrame"          )
.bsf~bsf.import('java.awt.GridBagConstraints', "awtGBConstraints"  )
.bsf~bsf.import('java.awt.GridBagLayout'     , "awtGridBagLayout"  )
.bsf~bsf.import('java.awt.Insets'            , "awtInsets"         )
.bsf~bsf.import("java.awt.Label"             , "awtLabel"          )
.bsf~bsf.import("java.awt.TextArea"          , "awtTextArea"       )

        /* create labels                */
label1 = .awtLabel~new('Your question?')
label2 = .awtLabel~new(, 'Well, consider this answer:' )

        /* get static values from class */
scrNone   = .bsf~bsf.getStaticValue('java.awt.TextArea', 'SCROLLBARS_NONE')
scrVert   = .bsf~bsf.getStaticValue('java.awt.TextArea', 'SCROLLBARS_VERTICAL_ONLY')

        /* create text area objects     */
taQuery  = .awtTextArea~new("",  5, 80, scrNone)
taAnswer = .awtTextArea~new("", 15, 80, scrVert)

        /* make the answer text area non-editable       */
taAnswer~setEditable(.false)

        /* create the buttons           */
butAnswer = .awtButton~new(' Please answer me! ')
butLeave  = .awtButton~new(' Let us stop for dooday, o.k.? ' )

        /* create gridBagLayout & constraint    */
lay    = .awtGridBagLayout~new
layCon = .awtGBConstraints~new

        /* now define details of the GridBagLayout      */
layCon~fill     =layCon~HORIZONTAL
layCon~gridWidth=layCon~REMAINDER

inset = .awtInsets~new(5, 5, 5, 5)
layCon~bsf.setFieldValue( 'insets',     inset)

        /* register the constraints with the layout manager     */
lay ~~setConstraints(label1,    layCon)
lay ~~setConstraints(taQuery,   layCon)
lay ~~setConstraints(butAnswer, layCon)
lay ~~setConstraints(label2,    layCon)
lay ~~setConstraints(taAnswer,  layCon)
lay ~~setConstraints(butLeave,  layCon)

        /* create the frame window                              */
window = .awtFrame~new('ShootOut!')

        /* now add controls to window, change some settings of it       */
window ~~setLayout(lay)
window ~~add(label1) ~~add(taQuery)  ~~add(butAnswer)
window ~~add(Label2) ~~add(taAnswer) ~~add(butLeave)

        /* pack the elements, show the window, bring it to the front    */
window ~~pack ~~show ~~toFront

        /* define the events we are interested in and the text to be sent to us */
window    ~ bsf.addEventListener('window', 'windowClosing', 'call BSF "exit"')
butAnswer ~ bsf.addEventListener('action', '', 'call answer taQuery, taAnswer, answers')
butLeave  ~ bsf.addEventListener('action', '', 'call BSF "exit"')

answers = .stream~new( "ShootAnswers.txt")~arrayin      /* read answers from file       */

do forever      /* wait and fetch the text to be sent by Java           */
   a = bsf.pollEventText()      /* wait for an eventText to be sent     */
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown */
end
exit

::requires BSF.CLS    -- "requires" must be the first of the directives,
                        -- this one is needed for getting access to the Object Rexx
                        -- BSF wrapper classes

        /* react to pressing the answer button  */
::routine answer
   use  arg taQuery, taAnswer, answers  /* get names of TextAreas       */
   txt=taQuery~getText                  /* get text             */

   lf = "0a"x
   txt=txt~translate("  ", "0d0a"x)~space~strip('T')
   if txt~right(1) = "?" then           /* a question in hand?          */
   do
      newLine = "0a0a"x
      tmp     =        newLine || "*** your question: ***" || newLine || txt
      tmp     = tmp || newLine || "--- my answer to you! ---" || newLine
      pick    = random(1, answers~items)/* pick a number        */
      tmp     = tmp || answers~at(pick)

      call bsf 'invoke', taAnswer, 'append',  tmp /* append to answer text area   */
      call bsf 'invoke', taQuery,  'setText', ""
   end
   return

