#!/usr/bin/rexx
/*
   Name:    "ShootOut2.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in ShootOut2.rex"
                or
            "java org.apache.bsf.Main            -in ShootOut2.rex"
                or
            "rexxj ShootOut2.rex" (Windows)
                or
            "rexxj.sh ShootOut2.rex" (Unix)
                or
            "rexx ShootOut2.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

   Needs:    ooRexx, BSF4Rexx

   Date:    2001-04-22 -- *NOT* finished yet!
            2003-01-23 -- finished: had to correct BSF itself to allow "char" datatypes to be used
            2003-05-10, --rgf, adjusted usage of Java arrays to new (relaxed) OO-array support
            2005-06-05, ---rgf, adjusted to name changes of the BSF class methods
            2005-12-28, added Apache license

   Author:   Rony G. Flatscher, WU Wien University,

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   Changed:

            2008-08-23, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                                remove the first three chars from its result string)

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

        /* bsf.import Java classes          */
.bsf~bsf.import("java.awt.Button"             , "awtButton"         )
.bsf~bsf.import('java.awt.Frame'              , "awtFrame"          )
.bsf~bsf.import('java.awt.GridBagConstraints' , "awtGBConstraints"  )
.bsf~bsf.import('java.awt.GridBagLayout'      , "awtGridBagLayout"  )
.bsf~bsf.import('java.awt.Insets'             , "awtInsets"         )
.bsf~bsf.import("java.awt.Label"              , "awtLabel"          )
.bsf~bsf.import("java.awt.TextArea"           , "awtTextArea"       )
.bsf~bsf.import("java.awt.TextField"          , "awtTextField"      )
                                              ,
.bsf~bsf.import("java.awt.Dialog"             , "awtDialog"         )
.bsf~bsf.import("java.awt.MenuBar"            , "awtMenuBar"        )
.bsf~bsf.import("java.awt.Menu"               , "awtMenu"           )
.bsf~bsf.import("java.awt.MenuItem"           , "awtMenuItem"       )


        /* create labels                */
label1 = .awtLabel~new('Your question?')
label2 = .awtLabel~new('Well, consider this answer:' )

        /* get static values from class, save in .local environment     */
.local~scr.None   = .bsf~bsf.getStaticValue('java.awt.TextArea', 'SCROLLBARS_NONE')
.local~scr.Vert   = .bsf~bsf.getStaticValue('java.awt.TextArea', 'SCROLLBARS_VERTICAL_ONLY')

        /* create text area objects     */
taQuery  = .awtTextArea~new("",  5,  80, .scr.None)
taAnswer = .awtTextArea~new("" , 15, 80, .scr.Vert)

        /* make the answer text area non-editable       */
taAnswer~setEditable(.false)

        /* create the buttons           */
butAnswer = .awtButton~new(' Please answer me! ')
butLeave  = .awtButton~new(' Let us stop for dooday, o.k.? ' )

        /* create gridBagLayout & constraint    */
lay    = .awtGridBagLayout~new
layCon = .awtGBConstraints~new

        /* now define details of the GridBagLayout      */
layCon~fill     =layCon~HORIZONTAL
layCon~gridWidth=layCon~REMAINDER


inset = .awtInsets~new(5, 5, 5, 5)
layCon~bsf.setFieldValue( 'insets',  inset)
.local~lay.con=layCon   -- save for later use in the local environment under the name "LAY.CON"

        /* register the constraints with the layout manager     */
lay ~~setConstraints(label1,    layCon)
lay ~~setConstraints(taQuery,   layCon)
lay ~~setConstraints(butAnswer, layCon)
lay ~~setConstraints(label2,    layCon)
lay ~~setConstraints(taAnswer,  layCon)
lay ~~setConstraints(butLeave,  layCon)


        /* create and assemble menu     */
mb    = .awtMenuBar~new

m     = .awtMenu     ~new("File")
medit = .awtMenuItem ~new("Edit answers...")
mexit = .awtMenuItem ~new("Exit")
m ~~add(medit) ~~add(mexit)   -- add menu items to menu

mb ~add(m)                         -- add menu to menu bar

        /* create the frame window                              */
window = .awtFrame~new('ShootOut!')
window~~setMenuBar(mb)

        /* now add controls to window, change some settings of it       */
window ~~setLayout(lay)
window ~~add(label1) ~~add(taQuery)  ~~add(butAnswer)
window ~~add(Label2) ~~add(taAnswer) ~~add(butLeave)

        /* pack the elements, show the window, bring it to the front    */
window ~~pack ~~show ~~toFront

        /* define the events we are interested in and the text to be sent to us */
window    ~ bsf.addEventListener('window', 'windowClosing', 'call BSF "exit"')

butAnswer ~ bsf.addEventListener('action', '', 'call answer taQuery, taAnswer')
butLeave  ~ bsf.addEventListener('action', '', 'call BSF "exit"')

medit~bsf.addEventListener("action", "", "call pwd_popup 'show', window")
mexit~bsf.addEventListener("action", "", ".bsf~bsf.exit")

.local~file.name="ShootAnswers.txt"             /* save file name explicitly    */

        /* read answers from file       */
call read_answers

do forever      /* wait and fetch the text to be sent by Java           */
   a = bsf.pollEventText()     /* wait for an eventText to be sent     */
   say "... ["a"] ..."

   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown */
end
exit

::requires BSF.CLS    -- "requires" must be the first of the directives,
                        -- this one is needed for getting access to the Object Rexx
                        -- BSF wrapper classes


::routine read_answers
   s=.stream~new(.file.name)~~open("read")
   .local~answers=s~arrayin
   s~close

        /* react to pressing the answer button  */
::routine answer
   use  arg taQuery, taAnswer           /* get names of TextAreas                                       */
   txt=taQuery~getText                  /* get text             */

   lf = "0a"x
   txt=txt~translate("  ", "0d0a"x)~space~strip('T')
   if txt~right(1) = "?" then           /* a question in hand?          */
   do
      newLine = "0a0a"x
      tmp     =        newLine || "*** your question: ***" || newLine || txt
      tmp     = tmp || newLine || "--- my answer to you! ---" || newLine
      pick    = random(1, .answers~items)/* pick a number        */
      tmp     = tmp || .answers~at(pick)

      call bsf 'invoke', taAnswer, 'append',  tmp /* append to answer text area   */
      call bsf 'invoke', taQuery,  'setText', ""
   end
   return


   /* Password Popup            */
::routine pwd_popup
   parse arg action

   if action="show" then        /* set up and show dialog       */
   do
       -- create an invisible window
       if \.local~hasentry("pop.win") then
       do
           use arg _, window    -- get owner of this (modal) dialog
           .local~pop.win    = .awtDialog~new(window, "Password check!")
                -- define a grid layout for this dialog
           .pop.win~setLayout(.bsf~new("java.awt.GridLayout", .array~of(2, 2) ))

           .local~pop.tf     = .awtTextField~new

           .pop.tf~~setEchoChar("*")

           pop.ok = .awtButton~new("O.K.!")
           pop.no = .awtButton~new("Abort")

                -- add the components
           .pop.win ~~add(.awtLabel~new("Password? ('hey')")) ~~add(.pop.tf)
           .pop.win ~~add(pop.ok) ~~add(pop.no)

               -- define eventListeners
           pop.ok   ~~bsf.addEventListener("action", ""            ,  "call pwd_popup 'button', 'ok'")
           pop.no   ~~bsf.addEventListener("action", ""            ,  "call pwd_popup 'button', 'no'")
           .pop.win ~~bsf.addEventListener("window", "windowClosing", "call pwd_popup 'button', 'no'")
           .pop.win ~~setResizable(.false) ~~pack
       end
       -- make dialog visible
       .pop.win ~~show
   end
   else if action="button" then         -- button was pressed
   do
      if arg(2)="no" then       -- Abort button was pressed, just hide
      do
         .pop.win ~~hide          -- hide dialog

      end
      else
      do
         txt= .pop.tf~getText   -- get text
         if txt \= "hey" then   -- wrong password, make entry visible
         do
            call beep 2500, 200
--            .pop.tf~setEchoChar("char", "0"x)
            .pop.tf~setText(.pop.tf~getText)
            .pop.win ~~show
         end
         else
         do     -- add the next eventText to the eventList
            .bsf~bsf.postEventText("call edit_popup 'show', window, answers")
            .pop.win ~~hide       -- hide dialog
         end
      end
   end
   return



   /* Popup window for editing answers. */
::routine edit_popup
   parse arg action

   if action="show"  then       /* set up and show dialog       */
   do
       -- create an invisible window
       if \.local~hasentry("pop_edit.win") then
       do
           use arg _, window          -- get owner of this (modal) dialog
           .local~pop_edit.win    = .awtDialog~new(window, "Edit Answers!")

           .local~pop_edit.ta = .awtTextArea~new("" , 27, 80, .scr.Vert)
           .local~pop_edit.tf = .awtTextField~new
           pop_edit.ok = .awtButton~new("O.K., save and use my changes!")
           pop_edit.no = .awtButton~new("Abort, please just return, will you?")

                -- define the layout
           lay    = .awtGridBagLayout~new
           .pop_edit.win ~~setLayout(lay)

           lay ~~setConstraints(.pop_edit.ta, .lay.Con)
           lay ~~setConstraints(pop_edit.ok,  .lay.Con)
           lay ~~setConstraints(pop_edit.no,  .lay.Con)

                -- add the components
           .pop_edit.win ~~add(.pop_edit.ta) ~~add(pop_edit.ok) ~~add(pop_edit.no)

               -- define eventListeners
           pop_edit.ok   ~~bsf.addEventListener("action", "", "call edit_popup 'button', 'ok'")
           pop_edit.no   ~~bsf.addEventListener("action", "", "call edit_popup 'button', 'no'")
           .pop_edit.win ~~bsf.addEventListener("window", "windowClosing", "call edit_popup 'button', 'no'")
           .pop_edit.win ~~pack

               -- set answers text
          txt=charin(.file.name, 1, stream(.file.name, "C", "QUERY SIZE"))

          call bsf "invokeStrict", .pop_edit.ta, "setText", "str", txt
       end
       -- make dialog visible
       .pop_edit.win ~~setResizable(.false) ~~show
   end
   else if action="button" then         -- button was pressed
   do
      if arg(2)="no" then               -- Abort button was pressed, just hide
      do
         .pop_edit.win~hide             -- hide dialog
      end
      else
      do
         call stream .file.name, "c", "open write replace"
         txt= .pop_edit.ta~getText      -- get text
         do while txt <> ""
            parse var txt before "." txt
            before=before~translate("  ", "0d0a"x)~space~strip('T')   -- remove empty lines and spaces
            if before = "" then iterate
            call lineout .file.name, before || "."
         end
         call stream .file.name, "C", "close"

say "just wrote something to" .file.name", now re-reading ..."

         call read_answers
         .pop_edit.win~hide             -- hide dialog
      end
   end
say ".pop_edit.win~isModal:" .pop_edit.win~isModal

   return



