#!/usr/bin/rexx
/*
   Name:    "ShowCount.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in ShowCount.rex"
                or
            "java org.apache.bsf.Main            -in ShowCount.rex"
                or
            "rexxj Showcount.rex" (Windows)
                or
            "rexxj.sh Showcount.rex" (Unix)
                or
            "rexx Showcount.rex"

   Purpose:  create a little resizable window with a push button to count and reveal
             the number of times the button was pressed

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx"
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-04-30 (at the 12th International Rexx Symposium), 2003-01-23, 2003-05-10, 2005-06-05
            2005-12-28, added Apache license

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)
             (cf. "http://nestroy.wi-inf.uni-essen.de/Lv/seminare/ws0001/index-e.html");

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   Changed:

            2008-08-23, ---rgf, if using BSF.CLS, then do not use BSF() directly (or
                                remove the first three chars from its result string)

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

.bsf~bsf.import("java.awt.Frame" , "awtFrame" )
.bsf~bsf.import("java.awt.Button", "awtButton")
.bsf~bsf.import("java.awt.Label"  ,"awtLabel" )

win=.awtFrame~new("Show Count")
win~bsf.addEventListener('window', 'windowClosing', '.bsf~bsf.exit')

but=.awtButton~new("Press me!")
but~bsf.addEventListener('action', '', 'call ShowCount')

lab=.awtLabel~new ~~setAlignment(1)

win ~~add("Center", lab) ~~add("South", but)
win ~~pack ~~show ~~toFront

i=0             /* set counter to 0     */

do forever
   a = bsf.pollEventText()     /* wait for an eventText to be sent     */
   say "received the following eventText: ["a"]"
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown in 1/10sec      */
end

exit

        /* show the actual number of times, you pressed the button      */
ShowCount:
   i=i+1
   lab~setText("Press #" i)
   return

::requires BSF.CLS    -- get access to the Object Rexx support enhancement
